// $Id: treeview.cc,v 1.4 2003/11/03 07:39:00 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "container.hh"

class Gtk_TreeView : public Gtk_Container
{public:
	typedef Gtk_Container Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_TreeView();
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
	virtual const std::string SignalHandlerArgs(const Widget &w,const std::string &signal,std::string &rettype,std::string &scope) const;
};

static Gtk_TreeView Gtk_TreeView;

const std::string Gtk_TreeView::TypeName(const Widget &w) const
{  return GtkPrefix()+"TreeView";
}

const std::string Gtk_TreeView::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"treeview.h";
}

Gtk_TreeView::Gtk_TreeView()
{  Writer["GtkTreeView"]=this;
}

void Gtk_TreeView::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   WriteBoolProperty(w,f,instance, "headers_visible");
   WriteBoolProperty(w,f,instance, "rules_hint");
   WriteBoolProperty(w,f,instance, "reorderable");
   WriteBoolProperty(w,f,instance, "enable_search");
   WriteBoolProperty(w,f,instance, "headers_clickable");
   WriteIntProperty(w,f,instance, "search_column");
   WriteEnumPropertyNS(w,f,instance, "hadjustment");
   WriteEnumPropertyNS(w,f,instance, "vadjustment");
}

const std::string Gtk_TreeView::SignalHandlerArgs(const Widget &w,const std::string &signal,std::string &rettype,std::string &scope) const
{  scope=Gtk_TreeView::TypeName(w);
   if (signal=="set_scroll_adjustments") return "Gtk::Adjustment* hadjustment,Gtk::Adjustment* vadjustment";
   else if (signal=="row_activated") return "const Gtk::TreeModel::Path& path, Gtk::TreeViewColumn* column";
   else if (signal=="test_expand_row" || signal=="test_collapse_row") 
   {  rettype="bool";
      return "const Gtk::TreeModel::iterator& iter, const Gtk::TreeModel::Path& path";
   }
   else if (signal=="row_expanded" || signal=="row_collapsed") 
      return "const Gtk::TreeModel::iterator& iter, const Gtk::TreeModel::Path& path";
   else if (signal=="move_cursor") 
   {  rettype="bool"; return "Gtk::MovementStep step, int count"; }
   else if (signal=="expand_collapse_cursor_row") 
   {  rettype="bool"; return "bool logical, bool expand, bool open_all"; }
   else if (signal=="select_cursor_row")
   {  rettype="bool";
      return "bool start_editing";
   }
   else if (signal=="cursor_changed" || signal=="columns_changed")
      return "";
   else if (signal=="toggle_cursor_row" || signal=="start_interactive_search"
   	|| signal=="select_all" || signal=="unselect_all" 
   	|| signal=="select_cursor_parent")
   {  rettype="bool";
      return "";
   }
   return Parent::SignalHandlerArgs(w,signal,rettype,scope);
}
