# sample script
# converts the selected text to upper case
# if no text is selected, is converts the hole buffer
# (C) 2000 Chicane (under GPL)

import glimmer
import string

if glimmer.has_selection():
    start = glimmer.selection_start()
    end = glimmer.selection_end()
    selection = 1
else:
    start = 0
    end = glimmer.buffer_size()
    selection = 0
file = glimmer.get_file_number()
len = glimmer.get_file_tab_width(file)
glimmer.freeze()
glimmer.move_to(start)
pos = start
replaced = 0
count = 0
while pos < end:
    c = glimmer.get_current_char()
    if c == ' ':
        count = count+1
        if count == len:
            glimmer.move(1)
            glimmer.delete_text(pos-(len-1), pos+1)
            glimmer.insert("\t")
            pos = pos-(len-1)
            replaced = replaced+(len-1)
            end = glimmer.buffer_size()
            count = 0
    else:
        count = 0
    pos = pos+1
    glimmer.move_to(pos)
if selection:
    glimmer.select_area(start, end-replaced)
glimmer.thaw()
