/*  Glimmer - dialogs.h
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _DIALOGS_H_
#define _DIALOGS_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "declarations.h"
#include "widgets/gdsfile.h"

gint file_dne_error (gchar * filename, GtkSignalFunc callback);
gint file_exists_error (gchar * filename, GtkSignalFunc callback);
gint file_not_saved (char *filename, GdsFile * file, GtkSignalFunc func_yes,
                     GtkSignalFunc func_no);
gint file_not_saved_no_close (char *filename, GdsFile * file,
                              GtkSignalFunc func_yes,
                              GtkSignalFunc func_no);
gint file_not_saved_save_as (char *filename, GdsFile * file,
                             GtkSignalFunc func_yes, GtkSignalFunc func_no);
gint file_externally_modified_reload (char *filename, GdsFile * file,
                                      GtkSignalFunc func_yes,
                                      GtkSignalFunc func_no);
void read_error (gchar * filename);
void save_error (gchar * filename);
void read_only (gchar * filename);
void create_error (gchar * filename);
void generic_dialog_with_text (gchar * text);
void error_dialog_with_text (const gchar * text);
gint bad_uri_data_dialog (const gchar * missing);

#ifdef __cplusplus
}
#endif
#endif
