/*  Glimmer - macro-language.c
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "declarations.h"
#include "macro-language.h"
#include "main.h"
#include "menus.h"
#include "misc.h"
#include "syntax-highlight.h"

static gint build_menu_from_scripts_dir (gchar * path, gchar * menu_path);
static void replace_char (char *text, char c1, char c2);

static GList *static_scripts = NULL;    //Scripts files
static GList *dynamic_scripts = NULL;   //Scripts entries
static GList *static_entries = NULL;    // Normal entries, but only the ones added whilst we were not parsing a syntax highlighting definition.

GList *dynamic_build = NULL;    // Build Entries (All, including whilst parsing a syntsx highlight definition)
GList *edit_entries = NULL;     // Popup menu entries

void
initialize_macro_language (int argc, char *argv[])
{
#ifdef WITH_PYTHON
    Py_Initialize ();
    PySys_SetArgv (argc, argv);
    PyImport_AddModule ("glimmer");
    init_scripting ();
    PyRun_SimpleString ("import glimmer");
    PyRun_SimpleString ("from glimmer import *");
    init_pygtk ();
#endif
    main_finish (NULL, argc, argv);
}

#ifdef WITH_PYTHON
void
execute_macro_string (char *string)
{
    PyRun_SimpleString (string);
}
#endif

#ifdef WITH_PYTHON
void
autoexec_script (void)
{
    gchar filename[256];
    FILE *autoexec_file;

    g_snprintf (filename, sizeof (filename), "%s/." PACKAGE "/autoexec.py",
                g_get_home_dir ());
    if ((autoexec_file = fopen (filename, "r"))) {
        PyRun_SimpleFile (autoexec_file, "autoexec.py");
        fclose (autoexec_file);
    }
}
#endif

#ifdef WITH_PYTHON
static gint
build_menu_from_scripts_dir (gchar * path, gchar * menu_path)
{
    DIR *dir_list;
    struct dirent *dir;
    struct stat st;
    gchar *label;
    gchar *text;
    gchar *mpath;
    GtkWidget *menu = NULL;
    GtkWidget *menu_item = NULL;
    gint items = 0;

    dir_list = opendir (path);
    if (!dir_list)
        return (0);
    while ((dir = readdir (dir_list))) {
        text = g_strconcat (path, "/", dir->d_name, NULL);
        stat (text, &st);
        g_free (text);
        if (!S_ISDIR (st.st_mode)) {
            if (strstr (dir->d_name, ".py")) {
                GnomeUIInfo new_menu[] = {
                    GNOMEUIINFO_END,
                    GNOMEUIINFO_END
                };

                label = get_file_wo_extension (dir->d_name);
                replace_char (label, '_', ' ');
                text = g_strconcat (path, "/", dir->d_name, NULL);
                new_menu[0].type = GNOME_APP_UI_ITEM;
                new_menu[0].label = label;
                new_menu[0].hint = NULL;
                new_menu[0].moreinfo = (gpointer) script_run_cb;
                new_menu[0].user_data = (gpointer) text;
                new_menu[0].unused_data = NULL;
                new_menu[0].pixmap_type = GNOME_APP_PIXMAP_NONE;
                new_menu[0].pixmap_info = NULL;
                gnome_app_insert_menus (GNOME_APP (app), menu_path,
                                        &new_menu[0]);
                menu_item = new_menu[0].widget;
                gtk_menu_reorder_child (GTK_MENU (menu_item->parent), menu_item,
                                        -1);
                gtk_object_set_data (GTK_OBJECT (menu_item), "path", text);
                static_scripts =
                    g_list_append (static_scripts, (gpointer) menu_item);
                g_free (label);
                items++;
            }
        } else if (strcmp (dir->d_name, ".") && strcmp (dir->d_name, "..")) {
            GnomeUIInfo new_menu[] = {
                GNOMEUIINFO_END,
                GNOMEUIINFO_END
            };
            GnomeUIInfo sub_menu[] = {
                GNOMEUIINFO_SEPARATOR,
                GNOMEUIINFO_END
            };

            label = g_strdup (dir->d_name);
            replace_char (label, '_', ' ');
            new_menu[0].type = GNOME_APP_UI_SUBTREE;
            new_menu[0].label = label;
            new_menu[0].hint = NULL;
            new_menu[0].moreinfo = (gpointer) sub_menu;
            new_menu[0].user_data = NULL;
            new_menu[0].unused_data = NULL;
            new_menu[0].pixmap_type = GNOME_APP_PIXMAP_NONE;
            new_menu[0].pixmap_info = NULL;
            new_menu[0].accelerator_key = 0;
            new_menu[0].ac_mods = (GdkModifierType) 0;
            new_menu[0].widget = NULL;
            gnome_app_insert_menus (GNOME_APP (app), menu_path, &new_menu[0]);
            menu_item = new_menu[0].widget;
            if (sub_menu[0].widget)
                menu = sub_menu[0].widget->parent;
            gtk_menu_reorder_child (GTK_MENU (menu_item->parent), menu_item,
                                    -1);
            static_scripts =
                g_list_append (static_scripts, (gpointer) menu_item);
            g_free (label);
            static_scripts = g_list_append (static_scripts, (gpointer) menu);
            text = g_strconcat (path, "/", dir->d_name, NULL);
            mpath = g_strconcat (menu_path, dir->d_name, "/", NULL);
            items += build_menu_from_scripts_dir (text, mpath);
            g_free (text);
            g_free (mpath);
        }
    }
    closedir (dir_list);
    return (items);
}

static void
replace_char (char *text, char c1, char c2)
{
    int length;
    int index;

    length = strlen (text);
    for (index = 0; index < length; index++) {
        if (text[index] == c1)
            text[index] = c2;
    }
}
#endif

#ifdef WITH_PYTHON
void
build_scripts_menu (void)
{
    gchar path[384];

    g_snprintf (path, sizeof (path), PREFIX "/share/" PACKAGE "/scripts");
    build_menu_from_scripts_dir (path, "_Scripts/");
    g_snprintf (path, sizeof (path), "%s/." PACKAGE "/scripts",
                g_get_home_dir ());
    build_menu_from_scripts_dir (path, "_Scripts/");
    return;
}
#endif

#ifdef WITH_PYTHON
void
script_run_cb (GtkWidget * widget, gchar * filename)
{
    FILE *file;

    g_print (_("Executing Python script: %s\n"), filename);
    file = fopen (filename, "r");
    if (!file)
        return;
    PyRun_SimpleFile (file, filename);
    fclose (file);
    return;
}
#endif

#ifdef WITH_PYTHON
void
regenerate_scripts_cb (GtkWidget * widget, gpointer data)
{
    GList *current;
    gpointer text;

    current = static_scripts = g_list_reverse (static_scripts);
    while (current) {
        text = gtk_object_get_data (GTK_OBJECT (current->data), "path");
        if (text)
            g_free (text);
        if (GTK_IS_WIDGET (current->data))
            gtk_widget_destroy (GTK_WIDGET (current->data));
        current = current->next;
    }
    g_list_free (static_scripts);
    static_scripts = NULL;
    build_scripts_menu ();
}
#endif

#ifdef WITH_PYTHON
void
adjust_popup_menu (void)
{
    GList *list;
    GtkWidget *widget;

    if (!cur_file)
        return;
    for (list = g_list_first (edit_entries); list; list = list->next) {
        widget = (GtkWidget *) list->data;
        if (widget)
            gtk_widget_hide (widget);
    }
    if (!cur_file->tables)
        return;
    if (!cur_file->tables->menu_entries)
        return;
    for (list = g_list_first (edit_entries); list; list = list->next) {
        widget = (GtkWidget *) list->data;
        if (widget
            && g_list_nth_data (cur_file->tables->menu_entries,
                                g_list_index (cur_file->tables->menu_entries,
                                              list->data)))
            gtk_widget_show (widget);
    }
    adjust_build_menu ();
}
#endif

#ifdef WITH_PYTHON
void
adjust_build_menu (void)
{
    GList *list;
    GtkWidget *widget;

    if (!cur_file)
        return;
    for (list = g_list_first (dynamic_build); list; list = list->next) {
        widget = (GtkWidget *) list->data;
        if (widget)
            gtk_widget_hide (widget);
    }
    if (!cur_file->tables)
        return;
    if (!cur_file->tables->menu_entries)
        return;
    for (list = g_list_first (dynamic_build); list; list = list->next) {
        widget = (GtkWidget *) list->data;
        if (widget
            && g_list_nth_data (cur_file->tables->menu_entries,
                                g_list_index (cur_file->tables->menu_entries,
                                              list->data))) {
            gtk_widget_show (widget);
        }
    }
}
#endif

#ifdef WITH_PYTHON
void
remove_pyref (GtkWidget * widget, PyObject * object)
{
    Py_DECREF (object);
}
#endif

#ifdef WITH_PYTHON
void
call_python_function_cb (GtkWidget * widget, gpointer * function)
{
    PyObject *result;

    g_assert (PyCallable_Check ((PyObject *) function));
    result = PyObject_CallObject ((PyObject *) function, NULL);
    Py_XDECREF (result);
}
#endif

#ifdef WITH_PYTHON
#include "bindings-python.c"
#endif
