/*  Glimmer - splash.c
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "splash.h"

SplashScreen *
splash_screen_build (gchar * auth_info, gchar * pixmap)
{
    SplashScreen *splash;
    GtkWidget *frame;
    GtkWidget *box;

    splash = g_malloc0 (sizeof (SplashScreen));
    splash->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title (GTK_WINDOW (splash->window), "Starting Glimmer...");
    frame = gtk_frame_new (NULL);
    gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
    gtk_container_add (GTK_CONTAINER (splash->window), frame);
    box = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (frame), box);
    splash->pixmap = gnome_pixmap_new_from_file (pixmap);
    gtk_box_pack_start (GTK_BOX (box), splash->pixmap, FALSE, FALSE, 0);
    splash->pixmap_box = gtk_hbox_new (TRUE, 0);
    gtk_box_pack_start (GTK_BOX (box), splash->pixmap_box, TRUE, TRUE, 0);
    splash->auth_info = gtk_label_new (auth_info);
    gtk_box_pack_start (GTK_BOX (box), splash->auth_info, FALSE, FALSE, 0);
    frame = gtk_frame_new (NULL);
    gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
    gtk_box_pack_start (GTK_BOX (box), frame, FALSE, FALSE, 0);
    splash->init_info = gtk_label_new ("");
    gtk_container_add (GTK_CONTAINER (frame), splash->init_info);
    gtk_window_set_policy (GTK_WINDOW (splash->window), FALSE, FALSE, FALSE);
    gtk_window_set_position (GTK_WINDOW (splash->window),
                             GTK_WIN_POS_CENTER_ALWAYS);
    return (splash);
}

void
splash_screen_append_icon (SplashScreen * splash, gchar * gnome_icon)
{
    GtkWidget *pixmap;

    pixmap =
        gnome_stock_pixmap_widget_at_size (splash->window, gnome_icon, 24, 24);
    gtk_box_pack_start (GTK_BOX (splash->pixmap_box), pixmap, TRUE, TRUE, 0);
    splash->pixmaps = g_list_append (splash->pixmaps, pixmap);
    gtk_widget_show (pixmap);
    gtk_widget_set_sensitive (pixmap, FALSE);
}

void
splash_screen_update_next_icon (SplashScreen * splash)
{
    gtk_widget_set_sensitive (GTK_WIDGET
                              (g_list_nth_data
                               (splash->pixmaps, splash->index)), TRUE);
    while (gtk_events_pending ())
        gtk_main_iteration ();
    splash->index++;
}

void
splash_screen_update (SplashScreen * splash, gchar * text)
{
    gtk_label_set (GTK_LABEL (splash->init_info), text);
    while (gtk_events_pending ())
        gtk_main_iteration ();
}

void
splash_screen_die (SplashScreen * splash)
{
    gtk_widget_destroy (splash->window);
    g_free (splash);
}
