/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "config.h"

#include "dconnect.h"
#include "world.h"
#include "help.h"
#include "misc.h"
#include "window.h"

void connect_cancel(GtkWidget *w, connect_t *c) {
    if(debug) printf("Closing quick connect dialog\n");
    w = gtk_widget_get_toplevel(w);
    gtk_widget_hide(w);
    gtk_widget_destroy(w);
    g_free(c);
}

void connect_connect(GtkWidget *w, connect_t *c) {
    char *host = gtk_entry_get_text(GTK_ENTRY(c->hostname_w));
    int port = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c->port_w));

    if(debug) printf("Connecting quick connect dialog\n");
    gtk_widget_hide(gtk_widget_get_toplevel(w));
    gm_world_create_quick(host, port);
    connect_cancel(w, c);
}

void connect_delete_w(GtkWidget *window, GdkEvent *e, connect_t *c) {
    connect_cancel(window, c);
}

void connect_changed(GtkWidget *w, connect_t *c) {
    gtk_widget_set_sensitive(c->connect_but, TRUE);
    gtk_widget_grab_default(c->connect_but);
}

void connect_activated(GtkWidget *w, connect_t *c) {
    if(GTK_WIDGET_HAS_DEFAULT(c->connect_but)) {
	if(w == c->hostname_w) {
	    gtk_widget_grab_focus(c->port_w);
	} else {
	    gtk_widget_grab_focus(c->connect_but);
	    gtk_button_clicked(GTK_BUTTON(c->connect_but));
	}
    } else {
	connect_cancel(w, c);
    }
}

void gm_dialog_connect_open() {
    GtkWidget *window;
    GtkWidget *vbox;
    GtkWidget *table;
    GtkWidget *tmp;
    GtkWidget *hbb;
    GtkAdjustment *adj;
    connect_t *c;

    c = g_malloc(sizeof(connect_t));

    if(debug) printf("Opening Quick Connect dialog\n");

    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_transient_for(GTK_WINDOW(window),
				 GTK_WINDOW(gm_window_get_window()));
    gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_MOUSE);
    gtk_window_set_title (GTK_WINDOW (window), _("Quick Connect"));
    gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, TRUE);
    gtk_signal_connect(GTK_OBJECT(window), "delete_event",
		       GTK_SIGNAL_FUNC(connect_delete_w), c);

    vbox = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (vbox);
    gtk_container_add (GTK_CONTAINER (window), vbox);

    table = gtk_table_new (2, 2, FALSE);
    gtk_widget_show (table);
    gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (table), 5);
    gtk_table_set_row_spacings (GTK_TABLE (table), 5);
    gtk_table_set_col_spacings (GTK_TABLE (table), 5);

    tmp = gtk_label_new (_("Port"));
    gtk_widget_show (tmp);
    gtk_table_attach (GTK_TABLE (table), tmp, 0, 1, 1, 2,
		      (GtkAttachOptions) (GTK_FILL),
		      (GtkAttachOptions) (0), 0, 0);
    gtk_misc_set_alignment (GTK_MISC (tmp), 1, 0.5);

    tmp = gtk_label_new (_("Hostname"));
    gtk_widget_show (tmp);
    gtk_table_attach (GTK_TABLE (table), tmp, 0, 1, 0, 1,
		      (GtkAttachOptions) (GTK_FILL),
		      (GtkAttachOptions) (0), 0, 0);
    gtk_misc_set_alignment (GTK_MISC (tmp), 1, 0.5);

    c->hostname_w = gtk_entry_new ();
    gtk_widget_show (c->hostname_w);
    gtk_table_attach (GTK_TABLE (table), c->hostname_w, 1, 2, 0, 1,
		      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		      (GtkAttachOptions) (0), 0, 0);

    adj = GTK_ADJUSTMENT(gtk_adjustment_new(8888, 0, G_MAXINT, 1, 10, 10));
    c->port_w = gtk_spin_button_new(adj, 1, 0);
    gtk_widget_show (c->port_w);
    gtk_table_attach (GTK_TABLE (table), c->port_w, 1, 2, 1, 2,
		      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		      (GtkAttachOptions) (0), 0, 0);

    tmp = gtk_hseparator_new ();
    gtk_widget_show (tmp);
    gtk_box_pack_start (GTK_BOX (vbox), tmp, FALSE, TRUE, 0);

    hbb = gtk_hbutton_box_new ();
    gtk_widget_show (hbb);
    gtk_box_pack_start (GTK_BOX (vbox), hbb, FALSE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbb), 5);
    gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbb), 0);
    gtk_button_box_set_child_size (GTK_BUTTON_BOX (hbb), 0, 0);

    c->connect_but = gtk_button_new_with_label (_("Connect"));
    gtk_widget_show (c->connect_but);
    gtk_container_add (GTK_CONTAINER (hbb), c->connect_but);
    GTK_WIDGET_SET_FLAGS (c->connect_but, GTK_CAN_DEFAULT);
    gtk_signal_connect(GTK_OBJECT(c->connect_but), "clicked",
		       GTK_SIGNAL_FUNC(connect_connect), c);
    gtk_widget_set_sensitive(c->connect_but, FALSE);

    tmp = gtk_button_new_with_label (_("Cancel"));
    gtk_widget_show (tmp);
    gtk_container_add (GTK_CONTAINER (hbb), tmp);
    GTK_WIDGET_SET_FLAGS (tmp, GTK_CAN_DEFAULT);
    gtk_widget_grab_default (tmp);
    gtk_signal_connect(GTK_OBJECT(tmp), "clicked",
		       GTK_SIGNAL_FUNC(connect_cancel), c);

    tmp = gtk_button_new_with_label (_("Help"));
    gtk_widget_show (tmp);
    gtk_container_add (GTK_CONTAINER (hbb), tmp);
    GTK_WIDGET_SET_FLAGS (tmp, GTK_CAN_DEFAULT);
    gtk_signal_connect(GTK_OBJECT(tmp), "clicked",
		       GTK_SIGNAL_FUNC(gm_help_show), HELP_DCONNECT);

    gtk_signal_connect(GTK_OBJECT(c->hostname_w), "changed",
		       GTK_SIGNAL_FUNC(connect_changed), c);
    gtk_signal_connect(GTK_OBJECT(c->port_w), "changed",
		       GTK_SIGNAL_FUNC(connect_changed), c);
    gtk_signal_connect(GTK_OBJECT(c->hostname_w), "activate",
		       GTK_SIGNAL_FUNC(connect_activated), c);
    gtk_signal_connect(GTK_OBJECT(c->port_w), "activate",
		       GTK_SIGNAL_FUNC(connect_activated), c);
    gtk_widget_grab_focus(c->hostname_w);

    gtk_widget_show(window);
}

