/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "config.h"
#include "window.h"
#include "settings.h"
#include "configdb.h"
#include "help.h"
#include "world.h"
#include "notebook.h"

void gm_dialog_open_close(GtkWidget *w) {
    w = gtk_widget_get_toplevel(w);
    gtk_widget_hide(w);
    gtk_widget_destroy(w);
}

void open_try_open(GtkButton *but, GtkWidget *clist) {
    char *name =gtk_object_get_data(GTK_OBJECT(gtk_widget_get_toplevel(clist)),
                                    "selection");
    if(!name) {
        if(debug) printf("No world selected\n");
        return;
    }
    name = g_strdup(name);

    gm_dialog_open_close(clist);
    if(debug) printf("Going to open world \"%s\" now\n", name);
    gm_notebook_try_add_world(name);

    g_free(name);
}

#define row_text(list, row) \
GTK_CLIST_ROW(g_list_nth(GTK_CLIST(list)->row_list, row))->cell->u.text

void open_select_row(GtkCList *clist, int row, int column, GdkEvent *e) {
    GtkWidget *win = gtk_widget_get_toplevel(GTK_WIDGET(clist));
    GtkWidget *open = gtk_object_get_data(GTK_OBJECT(win), "open");
    gtk_widget_set_sensitive(open, TRUE);
    gtk_widget_grab_default(open);
    gtk_object_set_data(GTK_OBJECT(win), "selection", row_text(clist, row));
}

void open_unselect_row(GtkCList *clist, int row, int column, GdkEvent *e) {
    GtkWidget *win = gtk_widget_get_toplevel(GTK_WIDGET(clist));
    GtkWidget *cancel = gtk_object_get_data(GTK_OBJECT(win), "cancel");
    GtkWidget *open = gtk_object_get_data(GTK_OBJECT(win), "open");
    gtk_widget_set_sensitive(open, FALSE);
    gtk_widget_grab_default(cancel);
    gtk_object_set_data(GTK_OBJECT(win), "selection", NULL);
}

void load_worlds(GtkCList *clist) {
    GList *worlds, *l;
    char *text[1];

    gtk_clist_clear(clist);

    worlds = gm_world_get_names();

    for(l = worlds; l; l = g_list_next(l)) {
        if(debug) printf("Adding world \"%s\"\n", (char *) (l->data));
        text[0] = (char *) (l->data);
        gtk_clist_append(clist, text);
    }

    g_list_foreach(worlds, (GFunc) g_free, NULL);
    g_list_free(worlds);

    if(clist->rows) {
        gtk_clist_select_row(clist, 0, 0);
    } else {
        open_unselect_row(clist, 0, 0, NULL);
    }
}

int open_button_press_event(GtkCList *clist, GdkEventButton *event) {
    if(event->type == GDK_2BUTTON_PRESS) {
	open_try_open(NULL, GTK_WIDGET(clist));
	return TRUE;
    }
    return FALSE;
}

void gm_dialog_open_open() {
    GtkWidget *window;
    GtkWidget *vbox;
    GtkWidget *scrolledwindow;
    GtkWidget *clist;
    GtkWidget *tmp;
    GtkWidget *open_button, *cancel_button;
    GtkWidget *hbuttonbox;

    if(debug) printf("Opening Open world dialog\n");

    window = gtk_window_new (GTK_WINDOW_DIALOG);
    gtk_window_set_transient_for(GTK_WINDOW(window),
				 GTK_WINDOW(gm_window_get_window()));
    gtk_object_set_data (GTK_OBJECT (window), "window", window);
    gtk_window_set_title (GTK_WINDOW (window), _("Open a world"));

    gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_MOUSE);
    gtk_window_set_policy (GTK_WINDOW (window), TRUE, TRUE, FALSE);
    gtk_window_set_wmclass (GTK_WINDOW (window), "gmoo_open_dialog", "gmoo");
    gtk_signal_connect(GTK_OBJECT(window), "delete_event",
                       GTK_SIGNAL_FUNC(gm_dialog_open_close), (void *) window);
    gtk_window_set_default_size(GTK_WINDOW(window), -1, 200);

    vbox = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (vbox);
    gtk_container_add (GTK_CONTAINER (window), vbox);
    
    scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
    gtk_widget_show (scrolledwindow);
    gtk_box_pack_start (GTK_BOX (vbox), scrolledwindow, TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (scrolledwindow), 5);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW (scrolledwindow), 
				   GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    clist = gtk_clist_new(1);
    gtk_widget_show(clist);
    gtk_container_add(GTK_CONTAINER(scrolledwindow), clist);
    gtk_widget_set_usize(clist, 150, -1);
    gtk_clist_set_column_auto_resize(GTK_CLIST(clist), 0, TRUE);
    gtk_clist_column_titles_show(GTK_CLIST(clist));
    gtk_clist_set_selection_mode(GTK_CLIST(clist), GTK_SELECTION_BROWSE);
    gtk_signal_connect(GTK_OBJECT(clist), "select_row",
		       GTK_SIGNAL_FUNC(open_select_row), NULL);
    gtk_signal_connect(GTK_OBJECT(clist), "unselect_row",
		       GTK_SIGNAL_FUNC(open_unselect_row), NULL);
    gtk_signal_connect(GTK_OBJECT(clist), "button_press_event",
		       GTK_SIGNAL_FUNC(open_button_press_event), NULL);
	
    tmp = gtk_label_new(_("Worlds"));
    gtk_widget_show(tmp);
    gtk_clist_set_column_widget(GTK_CLIST(clist), 0, tmp);
    gtk_label_set_justify(GTK_LABEL(tmp), GTK_JUSTIFY_LEFT);
    gtk_misc_set_alignment(GTK_MISC(tmp), 0, 0.5);
    gtk_misc_set_padding(GTK_MISC(tmp), 5, 0);

    tmp = gtk_hseparator_new ();
    gtk_widget_show (tmp);
    gtk_box_pack_start (GTK_BOX (vbox), tmp, FALSE, FALSE, 5);
    
    hbuttonbox = gtk_hbutton_box_new ();
    gtk_widget_show (hbuttonbox);
    gtk_container_set_border_width(GTK_CONTAINER(hbuttonbox), 5);
    gtk_box_pack_start (GTK_BOX (vbox), hbuttonbox, FALSE, FALSE, 0);
    gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox), GTK_BUTTONBOX_END);
    gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbuttonbox), 0);
    gtk_button_box_set_child_size (GTK_BUTTON_BOX (hbuttonbox), 0, 0);
    
    open_button = gtk_button_new_with_label (_("Open"));
    gtk_widget_show (open_button);
    gtk_container_add (GTK_CONTAINER (hbuttonbox), open_button);
    GTK_WIDGET_SET_FLAGS (open_button, GTK_CAN_DEFAULT);
    gtk_signal_connect(GTK_OBJECT(open_button), "clicked",
		       GTK_SIGNAL_FUNC(open_try_open), clist);
    
    cancel_button = gtk_button_new_with_label (_("Cancel"));
    gtk_widget_show (cancel_button);
    gtk_container_add (GTK_CONTAINER (hbuttonbox), cancel_button);
    GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);
    gtk_signal_connect(GTK_OBJECT(cancel_button), "clicked",
                       GTK_SIGNAL_FUNC(gm_dialog_open_close), NULL);
    
    tmp = gtk_button_new_with_label (_("Help"));
    gtk_widget_show (tmp);
    gtk_container_add (GTK_CONTAINER (hbuttonbox), tmp);
    GTK_WIDGET_SET_FLAGS (tmp, GTK_CAN_DEFAULT);
    gtk_signal_connect(GTK_OBJECT(tmp), "clicked",
                       GTK_SIGNAL_FUNC(gm_help_show), HELP_DOPEN);

    gtk_object_set_data(GTK_OBJECT(window), "open", open_button);
    gtk_object_set_data(GTK_OBJECT(window), "cancel", cancel_button);

    load_worlds(GTK_CLIST(clist));

    gtk_widget_grab_focus(clist);

    gtk_widget_show(window);

    if(debug) printf("Done opening Open world dialog\n");
}

