/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef GM_EDITOR_H
#define GM_EDITOR_H

#include <gtk/gtk.h>
#include <stdio.h>
#include <time.h>
#include <sys/types.h>

#include "world.h"
#include "config.h"

#define EDITOR(e)   ((editor_t *) (e))
#define I_EDITOR(e) ((i_editor_t *) (e))
#define IS_I_EDITOR(e) (EDITOR(e)->type == EDITOR_INTERNAL_TYPE)
#define E_EDITOR(e) ((e_editor_t *) (e))
#define IS_E_EDITOR(e) (EDITOR(e)->type == EDITOR_EXTERNAL_TYPE)

#ifdef ZVT
#   define E_TAB_EDITOR(e) ((e_tab_editor_t *) (e))
#   define IS_E_TAB_EDITOR(e) (IS_E_EDITOR(e) &&\
			       E_EDITOR(e)->has_notebook_page)
#endif

#define E_NOTAB_EDITOR(e) ((e_notab_editor_t *) (e))
#define IS_E_NOTAB_EDITOR(e) (IS_E_EDITOR(e) &&\
			      !(E_EDITOR(e)->has_notebook_page))

typedef struct _i_editor_t i_editor_t;
typedef struct _e_editor_t e_editor_t;
typedef struct _e_tab_editor_t   e_tab_editor_t;
typedef struct _e_notab_editor_t e_notab_editor_t;
typedef struct _upload_inline_t upload_inline_t;
typedef struct _upload_mcp_t    upload_mcp_t;

typedef enum {
    EDITOR_INTERNAL_TYPE,
    EDITOR_EXTERNAL_TYPE
} EditorType;

typedef enum {
    UPLOAD_INLINE,
    UPLOAD_MCP
} UploadType;

struct _editor_t { /* GENERIC editor */
    EditorType type;          /* The type of the editor */
    world *belongs_to;        /* what world is belongs to */
    char *name;               /* The name of the editor */
    guint done_receiving : 1; /* TRUE if alle teh data is received */
    guint ok_to_close : 1;
    UploadType upload_type;   /* The way the data is uploaded */
    void *upload;     /* pointer to a struct that has all the specific info */
};

struct _i_editor_t { /* INTERNAL editor */
    editor_t parent; /* the parent struct */
    GtkWidget *main;
    GtkWidget *text;
    GtkWidget *upload_button;
    GtkWidget *close_button;
    GtkWidget *tab_label;
};

struct _e_editor_t { /* EXTERNAL editor */
    editor_t parent;             /* The parent struct */
    char *command;               /* The command to launch the editor */
    char *filename;              /* The filename of the file that is edited */
    FILE *file;
    time_t last_modified;
    int    check_change_id;
    guint has_notebook_page : 1; /* Is the editor is embedded in gmoo */
};

#ifdef ZVT
struct _e_tab_editor_t {
    e_editor_t parent;
    GtkWidget *main;
    GtkWidget *term;
    GtkWidget *tab_label;
};
#endif

struct _e_notab_editor_t {
    e_editor_t parent;
    pid_t pid;
    int check_closed_id;
};

struct _upload_inline_t {
    char *upload_command;
};

struct _upload_mcp_t {
    char *ref;
    char *type;
};


/* Creating and destroying */
void      gm_editor_new_from_oob      (world *w, const char *line);
editor_t *gm_editor_new_from_mcp      (world *w, const char *name,const char *ref,
                                       const char *type);
int       gm_editor_ok_to_close       (editor_t *e);
void      gm_editor_close             (editor_t *e);
void      gm_editor_world_disconnected(editor_t *e);

/* Adding data */
void gm_editor_add_line         (editor_t *e, const char *line, int linelen);
void gm_editor_all_data_received(editor_t *e);

/* misc */
void gm_editor_got_focus   (editor_t *e);
void gm_editor_set_position(editor_t *e, int pos);

#endif /* GM_EDITOR_H */
