/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <stdlib.h>
#include <signal.h>

#include "config.h"

#if defined(ZVT) || defined(IMLIB)
#   include <gdk_imlib.h>
#endif

#include "window.h"
#include "settings.h"
#include "script.h"
#include "run.h"
#include "notebook.h"
#include "statusbar.h"
#include "userlist.h"
#include "dtriggers.h"

#define DEFAULT_LABEL "gmoo successfully started"

void sighandler(int signal) {
    if(debug) printf("*** Got signal %d !\n", signal);
    gm_window_close();
}


void init_nls() {
    gtk_set_locale();
#ifdef ENABLE_NLS
    bindtextdomain(PACKAGE, LOCALEDIR);
    textdomain(PACKAGE);
#endif
}

int main(int argc, char *argv[]) {
    debug = FALSE;
    init_nls();

    gtk_init(&argc, &argv);

#if defined(ZVT) || defined(IMLIB)
    gdk_imlib_init();
#endif

    gm_settings_init(argc, argv);
#ifdef __TRIGGERS__
    gm_triggers_init();
#endif
#ifdef ZVT
    gm_run_init();
#endif
#ifdef SCRIPT
    gm_script_init(argv[0]);
#endif

    gm_window_init();

    gm_notebook_try_restore_status();

    gm_statusbar_set(_(DEFAULT_LABEL));

    gm_userlist_init();

    signal(SIGHUP, SIG_IGN);
    signal(SIGTERM, sighandler);
    signal(SIGINT, sighandler);

    gtk_main();

    gm_userlist_exit();

#ifdef ZVT
    gm_run_free();
#endif
#ifdef SCRIPT
    gm_script_exit();
#endif
#ifdef __TRIGGERS__
    gm_triggers_store();
#endif
    gm_settings_store(settings);

    return 0;
}
