#ifndef __GTK_GMO_H__
#define __GTK_GMO_H__

#include <gdk/gdk.h>
#include <gtk/gtkadjustment.h>
#include <gtk/gtkwidget.h>
#include <time.h>

#define GTK_GMO(obj)         GTK_CHECK_CAST (obj, gtk_gmo_get_type (), GtkGmo)
#define GTK_GMO_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, gtk_gmo_get_type (), GtkGmoClass)
#define GTK_IS_GMO(obj)      GTK_CHECK_TYPE (obj, gtk_gmo_get_type ())

typedef struct _GtkGmo GtkGmo;
typedef struct _GtkGmoClass GtkGmoClass;

#define BLACK   0
#define RED     1
#define GREEN   2
#define YELLOW  3
#define BLUE    4
#define MAGENTA 5
#define CYAN    6
#define WHITE   7
#define BRIGHT  8
#define FG_COLOR 16
#define BG_COLOR 17
#define FG_SELECT 18
#define BG_SELECT 19
#define NUM_COLORS 20


#define ATTR_IS_BOLD(attr)      ((attr) & (1 << 0))
#define ATTR_IS_UNDERLINE(attr) ((attr) & (1 << 1))
#define ATTR_IS_BLINK(attr)     ((attr) & (1 << 2))
#define ATTR_IS_FG(attr)        ((attr) & (1 << 8))
#define ATTR_IS_BG(attr)        ((attr) & (1 << 12))
#define ATTR_GET_FG(attr)       (((attr) & (7 << 9))  >> 9)
#define ATTR_GET_BG(attr)       (((attr) & (7 << 13)) >> 13)

#define ATTR_SET_BOLD(attr)      (attr) |= (1 << 0)
#define ATTR_SET_UNDERLINE(attr) (attr) |= (1 << 1)
#define ATTR_SET_BLINK(attr)     (attr) |= (1 << 2)
#define ATTR_SET_FG(attr, color) (attr) |=  (1 << 8);       \
    (attr) &= ~(7 << 9);       \
(attr) |=  ((color) << 9)
#define ATTR_SET_BG(attr, color) (attr) |=  (1 << 12);      \
    (attr) &= ~(7 << 13);      \
(attr) |=  ((color) << 13)

#define ATTR_CLEAR(attr)         attr = 0


#define DEFAULT_TIMESTAMP_FORMAT "[%H:%M:%S]"

    typedef struct GtkGmoLine {
	char    *line;              /* The string data */
	unsigned short length;      /* Length of the allocated string */
	unsigned short used_lines;  /* The # of lines used on screen */
	guint16 *attr;              /* Text attributes (color, bold, etc) */
	short select_start;
	short select_end;
	time_t timestamp;
    } GtkGmoLine;

struct _GtkGmo {
    GtkWidget widget;       /* The parent */

    GtkAdjustment *adj;     /* Adjustement for scrolling */
    int last_value;         /* last value of the adjustmen - check for upadte */
    
    GdkPixmap *buffer;      /* Cached screen for fast redraws. */
    GdkPixmap *background;  /* Cached bg pixmap */
    char *bgfilename;       /* filename to the backgound picture */
    int tiled;              /* is the bg is tiled insted of stretched */
    int transparent;        /* if we neet to get the imane from the root win. */
    int tinted;             /* If we need to tint the background image */
    guchar tint_r;          /* and how exactely ... */
    guchar tint_g;
    guchar tint_b;

    GdkGC *fgc;             /* Text foreground attributes */
    GdkGC *bgc;             /* Background attributes */

    GList *first_line;      /* GtkGmoLine structs */
    GList *last_line;       /* idem (DUH :) */
    int num_lines;
    int max_lines;

    GdkFont *font;          /* Font used for drawing */
    int width;              /* Width in chars */
    int height;             /* Height in chars */
    int charheight;
    int charwidth;

    int margin_width;     /* width of the left margin (it containes oa
			     the timestamp */ 
    char *timestamp;        /* The format of the timestamp compatible with
			       strftime, NULL if no timestamp will be displayed */

    GdkColor colors[NUM_COLORS]; /* color structs */

    int select_start_x;         /* X pos when the dragging began */
    int select_start_y;         /* Y pos. */
    int select_end_x;           /* blah */
    int select_end_y;           /* ... */

    guint16 attr;               /* last know attrubutes, default for new line */

    int scroll_id;              
    int blink_id;
    int redraw_id;
    int trans_refresh_id;

    unsigned int selecting : 1; /* If the user is dragging the selection */
    unsigned int word_or_line_select : 1; /* where we are double clicking */
    unsigned int blink_on : 1;
    unsigned int blinking : 1;
    unsigned int beep : 1; /* If we are gonna beep or not */
    unsigned int scroll_on_text : 1;
};

struct _GtkGmoClass {
    GtkWidgetClass parent_class;
    void (*resized_in_chars) (GtkGmo *gmo, int width, int height);
    void (*set_scroll_adjustments) (GtkGmo *text,
				    GtkAdjustment  *hadjustment,
				    GtkAdjustment  *vadjustment);
};

GtkWidget *gtk_gmo_new     ();
guint      gtk_gmo_get_type(void);

void gtk_gmo_clear         (GtkGmo     *gmo);
void gtk_gmo_append_line   (GtkGmo     *gmo,
			    const char *text,
			    int         len);

/* refreshed the background if needed for trancparency issues. */
void gtk_gmo_refresh_background(GtkGmo *gmo);
void gtk_gmo_set_background(GtkGmo *gmo, const char *bgfilename,
			    int tiled,
			    int transparent,
			    int tinted,
			    guchar tint_r, guchar tint_g, guchar tint_b);

void gtk_gmo_set_font      (GtkGmo     *gmo,
			    GdkFont    *font,
			    const char *name);
void gtk_gmo_set_palette   (GtkGmo   *gmo,
			    GdkColor  palette[]);

void gtk_gmo_set_timestamp (GtkGmo     *gmo,
			    const char *format);
void gtk_gmo_set_beep(GtkGmo *gmo, int beep);
void gtk_gmo_set_scroll_on_text(GtkGmo *gmo, int scroll);

void gtk_gmo_set_max_lines(GtkGmo *gmo, int max_lines);

#endif
