/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef GM_PROPERTIES_H
#define GM_PROPERTIES_H

#include "config.h"
#include "world.h"

/* Template directory name */
#define TEMPLATE "Template"

struct _properties_t {
    char *name;     /* The name of the world */
    char *hostname; /* The hostname (to conenct to) */
    int   port;     /* The port */
    int   autologin;/* Is we need to autologin */
    int   savelogin;/* do we save login if not autologging in*/
    char *username; /* Username, and */
    char *password; /* Password */
    int input_height; /* number of pixels avalible for the input bar */
    int userlist_width; /* width of the userlist */

    int log_use;
    int log_input;
    int log_color;
    int log_type;
#ifdef ZLIB
    int compressed_logs;
#endif
};

     /* apply changes */
void gm_properties_apply(world *w, properties_t *new);
     /* copy one into the other */
properties_t *gm_properties_copy(properties_t *from);
     /* store in a file */
void gm_properties_store(properties_t *p, const char *filename);
     /* load from a file */
properties_t *gm_properties_load(const char *filename);
     /* free the properties */
void gm_properties_free(properties_t *p);

#endif
