/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "config.h"

GtkWidget *statusbar_label;
GtkWidget *statusbar_label_frame;
GtkWidget *statusbar_clock;
GtkWidget *statusbar_clock_frame;

GtkWidget *gm_statusbar_create() {
    GtkWidget *frame;
    GtkWidget *hbox;
  
    frame = gtk_frame_new(NULL);
    gtk_widget_show(frame);
    gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);

    hbox = gtk_hbox_new(FALSE, 5);
    gtk_widget_show(hbox);
    gtk_container_add(GTK_CONTAINER(frame), hbox);

    statusbar_label_frame = gtk_frame_new(NULL);
    gtk_widget_show(statusbar_label_frame);
    gtk_box_pack_start(GTK_BOX(hbox), statusbar_label_frame, TRUE, TRUE, 0);
    gtk_frame_set_shadow_type (GTK_FRAME(statusbar_label_frame), 
			       GTK_SHADOW_IN);

    statusbar_label = gtk_label_new("");
    gtk_widget_show (statusbar_label);
    gtk_container_add(GTK_CONTAINER(statusbar_label_frame), statusbar_label);
    gtk_misc_set_alignment (GTK_MISC (statusbar_label), 0, 0.5);
    gtk_misc_set_padding (GTK_MISC (statusbar_label), 5, 0);

    statusbar_clock_frame = gtk_frame_new(NULL);
    gtk_box_pack_start(GTK_BOX(hbox), statusbar_clock_frame, FALSE, TRUE, 0);
    gtk_frame_set_shadow_type(GTK_FRAME(statusbar_clock_frame), GTK_SHADOW_IN);

    statusbar_clock = gtk_label_new ("");
    gtk_widget_show (statusbar_clock);
    gtk_container_add (GTK_CONTAINER (statusbar_clock_frame), statusbar_clock);
    gtk_misc_set_padding (GTK_MISC (statusbar_clock), 5, 0);

    return frame;
}

void gm_statusbar_set(const char *text) {
    gtk_label_set_text(GTK_LABEL(statusbar_label), text ? text : "");
}
