/******************************************************************************\
 gnofin/text-export.c   $Revision: 1.5 $
 Copyright (C) 1999 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#include "common.h"
#include <string.h>
#include <errno.h>
#include "data-if.h"
#include "dialogs.h"
#include "record-stringizer.h"
#include "text-export.h"
#include "ui-record-list.h"

gboolean
text_export (GtkWindow *parent, const gchar *filename, const Bankbook *book)
{
  FILE *file;
  const GList *ac, *rc;
  UI_RecordListColumnInfo *ci;
  guint ncol;

  trace("");

  file = fopen (filename, "wt");
  if (file == NULL)
  {
    dialog_error (parent, _("Unable to write file: %s"), strerror (errno));
    return FALSE;
  }

  ncol = ui_record_list_get_column_info (&ci);

  for (ac=if_bankbook_get_accounts (book); ac; ac=ac->next)
  {
    Account *account = LIST_DEREF (Account, ac);
    guint i = 0;

    fprintf (file, "%s\n", if_account_get_name (account));

    fprintf (file, ci[i].label);
    for (i=1; i<ncol; ++i)
      fprintf (file, "\t%s", ci[i].label);
    fprintf (file, "\n");

    for (rc=if_account_get_records (account); rc; rc=rc->next)
    {
      RecordInfo rec = {0};
      Record *record = LIST_DEREF (Record, rc);
      gchar *text;

      if_record_get_info (record, 0, &rec);

      for (i=0; i<ncol; ++i)
      {
        text = stringize_record_field (NULL, 0, ci[i].field, &rec);
        fprintf (file, text);
	if (i == (ncol - 1))
	  fprintf (file, "\n");
	else
	  fprintf (file, "\t");
	g_free (text);
      }
    }
    if (ac->next)
      fprintf (file,"\n");
  }
  fclose (file);
  return TRUE;
}
