/******************************************************************************\
 gnofin/bankbook.c   $Revision: 1.10 $
 Copyright (C) 2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

//#define ENABLE_DEBUG_TRACE

#include "common.h"
#include <stdarg.h>
#include <gtk/gtksignal.h>
#include "bankbook.h"
#include "account.h"
#include "record-type.h"


static GtkObjectClass *parent_class;

enum
{
  ACCOUNT_INSERTED,
  ACCOUNT_DELETED,

  RECORD_INSERTED,
  RECORD_DELETED,

  ACCOUNT_INFO_CHANGED,
  RECORD_INFO_CHANGED,

  RECORD_LIST_INVALIDATED,
  TYPE_LIST_INVALIDATED,
  PAYEE_LIST_INVALIDATED,
  MEMO_LIST_INVALIDATED,
  CATEGORY_LIST_INVALIDATED,
  LINKED_ACCOUNT_LIST_INVALIDATED,

  BALANCE_CHANGED,
  HISTORY_CHANGED,
  DIRTY_FLAG_CHANGED,

  LAST_SIGNAL
};
static gint signals[LAST_SIGNAL] = {0};


/******************************************************************************
 * Signals
 */

static void
bankbook_finalize (GtkObject *object)
{
  Bankbook *book;

  trace ("");

  book = BANKBOOK (object);

  history_clear (&book->history);
  book->remember_events = 0;

  while (book->accounts)
  {
    Account *account = LIST_DEREF (Account, book->accounts);
    account_detach (account, TRUE);
  }

  while (book->record_types)
  {
    RecordType *type = LIST_DEREF (RecordType, book->record_types);
    record_type_detach (type);
  }

  while (book->category_cache.cache)
  {
    CachedString *cs = LIST_DEREF (CachedString, book->category_cache.cache);
    cached_string_detach (cs);
  }

  while (book->link_cache.cache)
  {
    CachedString *cs = LIST_DEREF (CachedString, book->link_cache.cache);
    cached_string_detach (cs);
  }

  if (book->record_types != NULL)
    g_warning ("Memory leak detected: record_types\n");
  if (book->payee_cache.length != 0)
    g_warning ("Memory leak detected: payee_cache\n");
  if (book->memo_cache.length != 0)
    g_warning ("Memory leak detected: memo_cache\n");
  if (book->category_cache.length != 0)
    g_warning ("Memory leak detected: category_cache\n");
  if (book->link_cache.length != 0)
    g_warning ("Memory leak detected: link_cache\n");
  if (book->accounts != NULL)
    g_warning ("Memory leak detected: accounts\n");
  
  GTK_OBJECT_CLASS (parent_class)->finalize (object);
}

static void
bankbook_shutdown (GtkObject *object)
{
  gtk_object_unref (object);
  parent_class->shutdown (object);
}

/******************************************************************************
 * Initialization
 */

static void
bankbook_class_init (GtkObjectClass *object_class)
{
  trace ("");

  parent_class = gtk_type_class (gtk_object_get_type ());

  signals[ACCOUNT_INSERTED] = 
    gtk_signal_new ("account_inserted",
    		    GTK_RUN_FIRST,
		    object_class->type,
		    GTK_SIGNAL_OFFSET (BankbookClass, account_inserted),
		    gtk_marshal_NONE__UINT,
		    GTK_TYPE_NONE, 1,
		    GTK_TYPE_UINT);

  signals[ACCOUNT_DELETED] = 
    gtk_signal_new ("account_deleted",
    		    GTK_RUN_FIRST,
		    object_class->type,
		    GTK_SIGNAL_OFFSET (BankbookClass, account_deleted),
		    gtk_marshal_NONE__UINT,
		    GTK_TYPE_NONE, 1,
		    GTK_TYPE_UINT);

  signals[RECORD_INSERTED] = 
    gtk_signal_new ("record_inserted",
    		    GTK_RUN_FIRST,
		    object_class->type,
		    GTK_SIGNAL_OFFSET (BankbookClass, record_inserted),
		    gtk_marshal_NONE__POINTER_UINT,
		    GTK_TYPE_NONE, 2,
		    GTK_TYPE_POINTER, GTK_TYPE_UINT);

  signals[RECORD_DELETED] = 
    gtk_signal_new ("record_deleted",
    		    GTK_RUN_FIRST,
		    object_class->type,
		    GTK_SIGNAL_OFFSET (BankbookClass, record_deleted),
		    gtk_marshal_NONE__POINTER_UINT,
		    GTK_TYPE_NONE, 2,
		    GTK_TYPE_POINTER, GTK_TYPE_UINT);

  signals[ACCOUNT_INFO_CHANGED] = 
    gtk_signal_new ("account_info_changed",
    		    GTK_RUN_FIRST,
		    object_class->type,
		    GTK_SIGNAL_OFFSET (BankbookClass, account_info_changed),
		    gtk_marshal_NONE__POINTER_UINT_UINT,
		    GTK_TYPE_NONE, 3,
		    GTK_TYPE_POINTER, GTK_TYPE_UINT, GTK_TYPE_UINT);

  signals[RECORD_INFO_CHANGED] = 
    gtk_signal_new ("record_info_changed",
    		    GTK_RUN_FIRST,
		    object_class->type,
		    GTK_SIGNAL_OFFSET (BankbookClass, record_info_changed),
		    gtk_marshal_NONE__POINTER_UINT_UINT,
		    GTK_TYPE_NONE, 3,
		    GTK_TYPE_POINTER, GTK_TYPE_UINT, GTK_TYPE_UINT);

  signals[RECORD_LIST_INVALIDATED] = 
    gtk_signal_new ("record_list_invalidated",
    		    GTK_RUN_FIRST,
		    object_class->type,
		    GTK_SIGNAL_OFFSET (BankbookClass, record_list_invalidated),
		    gtk_marshal_NONE__POINTER,
		    GTK_TYPE_NONE, 1,
		    GTK_TYPE_POINTER);

  signals[TYPE_LIST_INVALIDATED] = 
    gtk_signal_new ("type_list_invalidated",
    		    GTK_RUN_FIRST,
		    object_class->type,
		    GTK_SIGNAL_OFFSET (BankbookClass, type_list_invalidated),
		    gtk_marshal_NONE__NONE,
		    GTK_TYPE_NONE, 0);

  signals[PAYEE_LIST_INVALIDATED] = 
    gtk_signal_new ("payee_list_invalidated",
    		    GTK_RUN_FIRST,
		    object_class->type,
		    GTK_SIGNAL_OFFSET (BankbookClass, payee_list_invalidated),
		    gtk_marshal_NONE__NONE,
		    GTK_TYPE_NONE, 0);

  signals[MEMO_LIST_INVALIDATED] = 
    gtk_signal_new ("memo_list_invalidated",
    		    GTK_RUN_FIRST,
		    object_class->type,
		    GTK_SIGNAL_OFFSET (BankbookClass, memo_list_invalidated),
		    gtk_marshal_NONE__NONE,
		    GTK_TYPE_NONE, 0);

  signals[CATEGORY_LIST_INVALIDATED] =
    gtk_signal_new ("category_list_invalidated",
		    GTK_RUN_FIRST,
		    object_class->type,
		    GTK_SIGNAL_OFFSET (BankbookClass, category_list_invalidated),
		    gtk_marshal_NONE__NONE,
		    GTK_TYPE_NONE, 0);

  signals[LINKED_ACCOUNT_LIST_INVALIDATED] =
    gtk_signal_new ("linked_account_list_invalidated",
		    GTK_RUN_FIRST,
		    object_class->type,
		    GTK_SIGNAL_OFFSET (BankbookClass, linked_account_list_invalidated),
		    gtk_marshal_NONE__NONE,
		    GTK_TYPE_NONE, 0);

  signals[BALANCE_CHANGED] = 
    gtk_signal_new ("balance_changed",
    		    GTK_RUN_FIRST,
		    object_class->type,
		    GTK_SIGNAL_OFFSET (BankbookClass, balance_changed),
		    gtk_marshal_NONE__POINTER,
		    GTK_TYPE_NONE, 1,
		    GTK_TYPE_POINTER);

  signals[HISTORY_CHANGED] = 
    gtk_signal_new ("history_changed",
    		    GTK_RUN_FIRST,
		    object_class->type,
		    GTK_SIGNAL_OFFSET (BankbookClass, history_changed),
		    gtk_marshal_NONE__NONE,
		    GTK_TYPE_NONE, 0);

  signals[DIRTY_FLAG_CHANGED] = 
    gtk_signal_new ("dirty_flag_changed",
    		    GTK_RUN_FIRST,
		    object_class->type,
		    GTK_SIGNAL_OFFSET (BankbookClass, dirty_flag_changed),
		    gtk_marshal_NONE__NONE,
		    GTK_TYPE_NONE, 0);

  gtk_object_class_add_signals (object_class, signals, LAST_SIGNAL);

  object_class->finalize = bankbook_finalize;
  object_class->shutdown = bankbook_shutdown;
}

static void
bankbook_init (Bankbook *book)
{
  trace ("");

  history_init (&book->history, (gpointer) book);
}


/******************************************************************************
 * Interface
 */

GtkType
bankbook_get_type (void)
{
  static GtkType type = 0;

  if (!type)
  {
    GtkTypeInfo info = {
      "Bankbook",
      sizeof (Bankbook),
      sizeof (BankbookClass),
      (GtkClassInitFunc) bankbook_class_init,
      (GtkObjectInitFunc) bankbook_init,
      NULL,
      NULL,
      (GtkClassInitFunc) NULL
    };
    type = gtk_type_unique (gtk_object_get_type (), &info);
  }
  return type;
}

GtkObject *
bankbook_new ()
{
  trace ("");
  return GTK_OBJECT (gtk_type_new (bankbook_get_type ()));
}

void
bankbook_set_error (Bankbook *book, char *fmt, ... )
{
  static gchar buf[512];
  va_list ap;

  trace ("");

  va_start (ap, fmt);
  g_vsnprintf (buf, sizeof buf, fmt, ap);
  book->lasterr = buf;
  va_end (ap);
}

const gchar *
bankbook_get_error (Bankbook *book)
{
  trace ("");

  if (book->lasterr)
  {
    const gchar *lasterr = book->lasterr;
    book->lasterr = NULL;
    return lasterr;
  }
  else
    return _("None");
}
