/******************************************************************************\
 gnofin/data-events.h   $Revision: 1.3 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef DATA_EVENTS_H
#define DATA_EVENTS_H

#include "bankbook.h"
#include "history.h"


/* Event types queued up to record changes to the data structure 
 * for multi-level undo/redo */

typedef enum   _EventType              EventType;
typedef struct _EventAccountInsert     EventAccountInsert;
typedef struct _EventAccountInsert     EventAccountDelete;
typedef struct _EventAccountSetInfo    EventAccountSetInfo;
typedef struct _EventRecordInsert      EventRecordInsert;
typedef struct _EventRecordInsert      EventRecordDelete;
typedef struct _EventRecordSetInfo     EventRecordSetInfo;
typedef struct _EventRecordTypeInsert  EventRecordTypeInsert;
typedef struct _EventRecordTypeInsert  EventRecordTypeDelete;
typedef struct _EventRecordTypeSetInfo EventRecordTypeSetInfo;

enum _EventType
{
  EVENT_ACCOUNT_INSERT,
  EVENT_ACCOUNT_DELETE,
  EVENT_ACCOUNT_SET_INFO,
  EVENT_RECORD_INSERT,
  EVENT_RECORD_DELETE,
  EVENT_RECORD_SET_INFO,
  EVENT_RECORD_TYPE_INSERT,
  EVENT_RECORD_TYPE_DELETE,
  EVENT_RECORD_TYPE_SET_INFO,
};

struct _EventAccountInsert
{
  Account *account;
};

struct _EventAccountSetInfo
{
  Account     *account;
  guint        mask;
  AccountInfo  info;
};

struct _EventRecordInsert
{
  Account *account;
  Record  *record;
};

struct _EventRecordSetInfo
{
  Record     *record;  /* we assume the record is attached (ie. it has a parent account) */
  guint       mask;
  RecordInfo  info;
  guint       breaks_link : 1;
};

struct _EventRecordTypeInsert
{
  RecordType *type;
};

struct _EventRecordTypeSetInfo
{
  RecordType     *type;
  guint           mask;
  RecordTypeInfo  info;
};


/* Call this function to register a history event (for multilevel undo/redo).
 * This function also implicitly calls the redo handler to "make the event happen"
 * so to speak.  If (data->remember_events) is false, the history event is not
 * queued, but the redo handler is still called. */
void realize_data_event (Bankbook *, EventType, gpointer event_data);


#endif

// vim: ts=8 sw=2
