/******************************************************************************\
 gnofin/gnofin-defaults.h   $Revision: 1.2 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef GNOFIN_DEFAULTS_H
#define GNOFIN_DEFAULTS_H

#include "data-types.h"

GNOFIN_API_BEGIN

/* For the moment this file is used to access the default bankbook
 * properties, such as the default record types, and the default
 * record categories. */

void install_default_record_types (Bankbook *book);
void install_default_categories   (Bankbook *book);

const GSList *get_default_record_types (void); /* returns reference */
const GSList *get_default_categories   (void); /* returns reference */

void set_default_record_types (GSList *types); /* assumes reference */
void set_default_categories   (GSList *cats);  /* assumes reference */

void restore_factory_default_record_types (void);
void restore_factory_default_categories   (void);
void restore_factory_defaults             (void);

GNOFIN_API_END

#endif
