/******************************************************************************\
 gnofin/money.h   $Revision: 1.5 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef MONEY_H
#define MONEY_H

#include <stdlib.h>
#include "notification-list.h"

GNOFIN_API_BEGIN

#define MONEY_IS_64BIT  G_HAVE_GINT64

#ifdef G_HAVE_GINT64
  typedef gint64 money_t;
#else
  typedef glong money_t;
#endif

#define money_sign(amount)  ((amount) < 0 ? -1 : +1)
#define money_abs(amount)   (amount < 0 ? -amount : amount)
#define money_major(amount) (money_abs (amount) / 100)
#define money_minor(amount) (money_abs (amount) % 100)

gchar   *money_stringize     (gchar *buf, int maxlen, money_t amount);
gchar   *money_stringize_f   (gchar *buf, int maxlen, money_t amount, gchar decimal_sep, gchar thousands_sep);
gchar   *money_stringize_raw (gchar *buf, int maxlen, money_t amount);
gboolean money_parse         (const gchar *buf, money_t *amount);
gboolean money_parse_f       (const gchar *buf, money_t *amount, gchar decimal_sep, gchar thousands_sep);
gboolean money_parse_raw     (const gchar *buf, money_t *amount);
gint     money_compare       (money_t a, money_t b);

gchar    money_get_decimal_sep   (void);
gchar    money_get_thousands_sep (void);

void     money_set_format (gchar decimal_sep, gchar thousands_sep);

/* Those interested in changes to the money format can attach to
 * this notification list */
extern NotificationList money_format_change_listeners;

GNOFIN_API_END

#endif

// vim: ts=8 sw=2
