/******************************************************************************\
 gnofin/notification-list.h   $Revision: 1.3 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef NOTIFICATION_LIST_H
#define NOTIFICATION_LIST_H

GNOFIN_API_BEGIN

typedef void (*NotificationFunc) (gpointer user_data);

#define NOTIFICATION_FUNC(f) ((NotificationFunc) f)

typedef struct {
  GSList *listeners;
} NotificationList;

void notification_list_add    (NotificationList *, NotificationFunc, gpointer user_data);
void notification_list_remove (NotificationList *, NotificationFunc);
void notification_list_notify (NotificationList *);

GNOFIN_API_END

#endif
