/******************************************************************************\
 gnofin/row-color.c   $Revision: 1.2 $
 Copyright (C) 2000 Luc Saillard <luc.saillard@alcove.fr>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#include "common.h"
#include <libgnome/gnome-config.h>
#include <gdk/gdk.h>
#include "row-color.h"
#include "config-saver.h"
#include "notification-list.h"


/******************************************************************************
 * Format change notification
 */

NotificationList row_color_change_listeners = {0};


/******************************************************************************
 * Configuration
 */

typedef struct {
  GdkColor row_color_bright_fg;
  GdkColor row_color_bright_bg;
  GdkColor row_color_dark_fg;
  GdkColor row_color_dark_bg;
} Config;

#define CAT  "UI_RowColor"
#define KEY  "/" PACKAGE "/" CAT "/"

static void load_config (Config *config)
{
  trace ("");

  /* Bright: #FFFFF7 Dark: #E0E6E0 */
  config->row_color_dark_fg.red=gnome_config_get_int(KEY "row_color_dark_fg_red=256");
  config->row_color_dark_fg.green=gnome_config_get_int(KEY "row_color_dark_fg_green=256");
  config->row_color_dark_fg.blue=gnome_config_get_int(KEY "row_color_dark_fg_blue=256");

  config->row_color_dark_bg.red=gnome_config_get_int(KEY "row_color_dark_bg_red=57344");
  config->row_color_dark_bg.green=gnome_config_get_int(KEY "row_color_dark_bg_green=58880");
  config->row_color_dark_bg.blue=gnome_config_get_int(KEY "row_color_dark_bg_blue=57344");

  config->row_color_bright_fg.red=gnome_config_get_int(KEY "row_color_bright_fg_red=256");
  config->row_color_bright_fg.green=gnome_config_get_int(KEY "row_color_bright_fg_green=256");
  config->row_color_bright_fg.blue=gnome_config_get_int(KEY "row_color_bright_fg_blue=256");

  config->row_color_bright_bg.red=gnome_config_get_int(KEY "row_color_bright_bg_red=65535");
  config->row_color_bright_bg.green=gnome_config_get_int(KEY "row_color_bright_bg_green=65535");
  config->row_color_bright_bg.blue=gnome_config_get_int(KEY "row_color_bright_bg_blue=63232");
}

static void save_config (const Config *config)
{
  trace ("");

  gnome_config_set_int(KEY "row_color_dark_fg_red", config->row_color_dark_fg.red);
  gnome_config_set_int(KEY "row_color_dark_fg_green", config->row_color_dark_fg.green);
  gnome_config_set_int(KEY "row_color_dark_fg_blue", config->row_color_dark_fg.blue);

  gnome_config_set_int(KEY "row_color_dark_bg_red", config->row_color_dark_bg.red);
  gnome_config_set_int(KEY "row_color_dark_bg_green", config->row_color_dark_bg.green);
  gnome_config_set_int(KEY "row_color_dark_bg_blue", config->row_color_dark_bg.blue);

  gnome_config_set_int(KEY "row_color_bright_fg_red", config->row_color_bright_fg.red);
  gnome_config_set_int(KEY "row_color_bright_fg_green", config->row_color_bright_fg.green);
  gnome_config_set_int(KEY "row_color_bright_fg_blue", config->row_color_bright_fg.blue);

  gnome_config_set_int(KEY "row_color_bright_bg_red", config->row_color_bright_bg.red);
  gnome_config_set_int(KEY "row_color_bright_bg_green", config->row_color_bright_bg.green);
  gnome_config_set_int(KEY "row_color_bright_bg_blue", config->row_color_bright_bg.blue);
}

static Config *get_config (void)
{
  static Config config;
  static gboolean init = FALSE;

  if (!init)
  {
    load_config (&config);
    config_saver_register (CAT, (ConfigSaveFunc) save_config, &config);
    init = TRUE;
  }
  return &config;
}


/******************************************************************************
 * Interface
 */

GdkColor *row_color_dark_fg (void)
{
  return &(get_config()->row_color_dark_fg);
}

GdkColor *row_color_dark_bg (void)
{
  return &(get_config()->row_color_dark_bg);
}

GdkColor *row_color_bright_fg (void)
{
  return &(get_config()->row_color_bright_fg);
}

GdkColor *row_color_bright_bg (void)
{
  return &(get_config()->row_color_bright_bg);
}


void row_color_set (const GdkColor *dark_fg,
		    const GdkColor *dark_bg,
		    const GdkColor *bright_fg,
		    const GdkColor *bright_bg)
{
  Config *config = get_config ();

  trace ("");

  config->row_color_dark_fg.red=dark_fg->red;
  config->row_color_dark_fg.green=dark_fg->green;
  config->row_color_dark_fg.blue=dark_fg->blue;

  config->row_color_dark_bg.red=dark_bg->red;
  config->row_color_dark_bg.green=dark_bg->green;
  config->row_color_dark_bg.blue=dark_bg->blue;

  config->row_color_bright_fg.red=bright_fg->red;
  config->row_color_bright_fg.green=bright_fg->green;
  config->row_color_bright_fg.blue=bright_fg->blue;

  config->row_color_bright_bg.red=bright_bg->red;
  config->row_color_bright_bg.green=bright_bg->green;
  config->row_color_bright_bg.blue=bright_bg->blue;
	
  /* notify those interested in changes to the row color. */
  notification_list_notify (&row_color_change_listeners);
}

void row_color_get (GdkColor *dark_fg,
		    GdkColor *dark_bg,
		    GdkColor *bright_fg,
		    GdkColor *bright_bg)
{
  Config *config = get_config ();

  trace ("");

  dark_fg->red=config->row_color_dark_fg.red;
  dark_fg->green=config->row_color_dark_fg.green;
  dark_fg->blue=config->row_color_dark_fg.blue;

  dark_bg->red=config->row_color_dark_bg.red;
  dark_bg->green=config->row_color_dark_bg.green;
  dark_bg->blue=config->row_color_dark_bg.blue;

  bright_fg->red=config->row_color_bright_fg.red;
  bright_fg->green=config->row_color_bright_fg.green;
  bright_fg->blue=config->row_color_bright_fg.blue;

  bright_bg->red=config->row_color_bright_bg.red;
  bright_bg->green=config->row_color_bright_bg.green;
  bright_bg->blue=config->row_color_bright_bg.blue;
}
