/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2003 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#ifndef __GNOME_CMD_CONNECTION_TYPES_H__
#define __GNOME_CMD_CONNECTION_TYPES_H__

#include "gnome-cmd-dir-types.h"
#include "gnome-cmd-device.h"
#include "gnome-cmd-ftp-server-types.h"
#include "imageloader.h"
#include "history.h"

typedef enum
{
	CON_TYPE_LOCAL,
	CON_TYPE_FTP,
	CON_TYPE_DEV
} GnomeCmdConnectionType;


typedef enum
{
	DEV_TYPE_DEFAULT,
	DEV_TYPE_FLOPPY,
	DEV_TYPE_CDROM	
} GnomeCmdDevType;


typedef struct
{
	GnomeCmdConnectionType type;
	GnomeCmdDir *cwd; // current working directory
	GnomeCmdDir *default_dir;
	GnomeVFSURI *base_uri;
	gchar *alias, *host;
	gchar *desc;
	gint id;
	GnomeCmdPixmap *pixmap;
	gboolean remember_dir;
	gchar *tooltip;
	History *dir_history;
	gchar *con_drop_tooltip;
	gchar *con_drop_text;

	/* only used when type == CON_TYPE_FTP */
	GnomeCmdFtpServer *server;
	
	/* used only when type == CON_TYPE_DEV */
	GnomeCmdDevice *device;

} GnomeCmdConnection;


#endif //__GNOME_CMD_CONNECTION_TYPES_H__
