/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2003 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#ifndef __GNOME_CMD_TYPES_H__
#define __GNOME_CMD_TYPES_H__

#include "gnome-cmd-ftp-server-types.h"


typedef char* GnomeCmdDateFormat;

typedef enum
{
	GNOME_CMD_LAYOUT_TEXT,
	GNOME_CMD_LAYOUT_TYPE_ICONS,
	GNOME_CMD_LAYOUT_MIME_ICONS
} GnomeCmdLayout;


typedef enum
{
	GNOME_CMD_SIZE_DISP_MODE_PLAIN,
	GNOME_CMD_SIZE_DISP_MODE_GROUPED,
	GNOME_CMD_SIZE_DISP_MODE_POWERED
} GnomeCmdSizeDispMode;


typedef enum
{
	GNOME_CMD_PERM_DISP_MODE_TEXT,
	GNOME_CMD_PERM_DISP_MODE_NUMBER
} GnomeCmdPermDispMode;


typedef struct {
	gchar *alias;
	GList *bookmarks;
	GnomeCmdFtpServer *server;
	gpointer *data;
} GnomeCmdBookmarkGroup;


typedef struct {
	gchar *name;
	gchar *path;
	GnomeCmdBookmarkGroup *group;
} GnomeCmdBookmark;


#endif //__GNOME_CMD_TYPES_H__
