/*
  GNOME Commander - A GNOME based file manager 
  Copyright (C) 2001-2003 Marcus Bjurman

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include <config.h>
#include "gnome-cmd-includes.h"
#include "support.h"
#include "utils.h"

GtkWidget*
lookup_widget                          (GtkWidget       *widget,
                                        const gchar     *widget_name)
{
	GtkWidget *parent, *found_widget;

	for (;;)
    {
		if (GTK_IS_MENU (widget))
			parent = gtk_menu_get_attach_widget (GTK_MENU (widget));
		else
			parent = widget->parent;
		if (parent == NULL)
			break;
		widget = parent;
    }

	found_widget = (GtkWidget*) gtk_object_get_data (GTK_OBJECT (widget),
													 widget_name);
	if (!found_widget)
		DEBUG ('w', "Widget not found: %s", widget_name);
	return found_widget;
}

/* This is an internally used function to create imlib images. */
GdkImlibImage*
create_image                           (const gchar     *filename)
{
	GdkImlibImage *image;
	gchar *pathname;

	pathname = gnome_pixmap_file (filename);
	if (!pathname)
    {
		g_warning (_("Couldn't find pixmap file: %s"), filename);
		return NULL;
    }

	image = gdk_imlib_load_image (pathname);
	g_free (pathname);
	return image;
}

