/* GDA Manager
 * Copyright (C) 1998,1999 Michael Lausch
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gnomedb-mgr.h"

static void
activate_dsn_tab_cb (BonoboUIComponent *uic, GnomeDbControl *control, const gchar *path)
{
	GtkWidget* notebook;
	
	notebook = gnome_db_control_get_widget(control);
	if (GTK_IS_NOTEBOOK(notebook))
		gtk_notebook_set_page(GTK_NOTEBOOK(notebook), 0);
}

static void
activate_providers_tab_cb (BonoboUIComponent *uic, GnomeDbControl *control, const gchar *path)
{
	GtkWidget* notebook;
	
	notebook = gnome_db_control_get_widget(control);
	if (GTK_IS_NOTEBOOK(notebook))
		gtk_notebook_set_page(GTK_NOTEBOOK(notebook), 1);
}

static void
new_dsn_cb (BonoboUIComponent *uic, GnomeDbControl *control, const gchar *path)
{
}

BonoboUIVerb manager_verbs [] = {
	BONOBO_UI_VERB ("ManagerNewDsn", new_dsn_cb),
	BONOBO_UI_VERB ("ManagerDsns", activate_dsn_tab_cb),
	BONOBO_UI_VERB ("ManagerProviders", activate_providers_tab_cb),
	BONOBO_UI_VERB_END
};

BonoboObject *
manager_control_new (void)
{
	GtkWidget*      notebook;
	GnomeDbControl* control;
	
	notebook = gnome_db_new_notebook_widget();
	gtk_notebook_set_show_border (GTK_NOTEBOOK (notebook), FALSE);
	gtk_notebook_set_show_tabs (GTK_NOTEBOOK (notebook), FALSE);
	gtk_notebook_popup_disable (GTK_NOTEBOOK (notebook));
	
	control = gnome_db_control_new(notebook);
	if (GNOME_DB_IS_CONTROL(control)) {
		manager_dsn_init(GTK_NOTEBOOK(notebook));
		manager_providers_init(GTK_NOTEBOOK(notebook));
		
		gnome_db_control_set_ui (control,
					 GNOMEDB_DATADIR,
					 "gnomedb-manager.xml",
					 manager_verbs,
					 control);
	}
	return BONOBO_OBJECT(control);
}

