/*  Gnometab -- a guitar tablature editor for GNOME
    Copyright (C) 2001  William L. Guelker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "render_gnomeprint.h"

void
set_linewidth(GnomePrintContext *ctx, real linewidth)
{  /* 0 == hairline **/

      gnome_print_setlinewidth(ctx, linewidth);
}

void
set_linecaps(GnomePrintContext *ctx, int ps_mode)
{
      gnome_print_setlinecap(ctx, ps_mode);
}

void
set_linejoin(GnomePrintContext *ctx, int ps_mode)
{
    gnome_print_setlinejoin(ctx, ps_mode);
}


void
draw_line(GnomePrintContext *ctx, 
      Point *start, Point *end, 
      Color *line_color)
{
      gnome_print_setrgbcolor(ctx,
              (double) line_color->red,
              (double) line_color->green,
              (double) line_color->blue);

    gnome_print_newpath(ctx);
    gnome_print_moveto(ctx, start->x, start->y);
    gnome_print_lineto(ctx, end->x, end->y);
    gnome_print_stroke(ctx);
}

void
draw_polyline(GnomePrintContext *ctx, 
          Point *points, int num_points, 
          Color *line_color)
{
      int i;
  
      gnome_print_setrgbcolor(ctx,
              (double) line_color->red,
              (double) line_color->green,
              (double) line_color->blue);

      gnome_print_newpath(ctx);
      gnome_print_moveto(ctx, points[0].x, points[0].y);

     for (i=1;i<num_points;i++) {
        gnome_print_lineto(ctx, points[i].x, points[i].y);
      }

     gnome_print_stroke(ctx);
}

void
draw_rect(GnomePrintContext *ctx, 
      Point *ul_corner, Point *lr_corner,
      Color *color)
{
      gnome_print_setrgbcolor(ctx, (double)color->red,
              (double)color->green, (double)color->blue);

      gnome_print_newpath(ctx);
      gnome_print_moveto(ctx, ul_corner->x, ul_corner->y);
      gnome_print_lineto(ctx, ul_corner->x, lr_corner->y);
     gnome_print_lineto(ctx, lr_corner->x, lr_corner->y);
      gnome_print_lineto(ctx, lr_corner->x, ul_corner->y);
      gnome_print_closepath(ctx);
      gnome_print_stroke(ctx);
}

void 
draw_string(GnomePrintContext *ctx,
        const char *text,
        Point *pos, int alignment,
        Color *color)
{
      
      gnome_print_setrgbcolor(ctx, (double)color->red,
              (double)color->green, (double)color->blue);

     gnome_print_moveto(ctx, pos->x, pos->y);
     
      gnome_print_gsave(ctx);
  
      if (text != NULL) gnome_print_show(ctx, text);
      gnome_print_grestore(ctx);
}

void
draw_arc(GnomePrintContext *ctx, Point *p1, Point *p2, Point *p3, 
                                            Color *color)
{
    gnome_print_setrgbcolor(ctx, (double)color->red,
              (double)color->green, (double)color->blue);
    
    gnome_print_newpath(ctx);
    gnome_print_moveto(ctx, p1->x, p1->y);
    gnome_print_curveto(ctx, p1->x, p1->y, p2->x, p2->y, p3->x, p3->y);
    /* gnome_print_closepath(ctx); */
    
    gnome_print_stroke(ctx);
}

void
draw_filled_arc(GnomePrintContext *ctx, Point *p1, Point *p2, Point *p3, 
                                            Color *color)
{
    gnome_print_setrgbcolor(ctx, (double)color->red,
              (double)color->green, (double)color->blue);
    
    gnome_print_newpath(ctx);
    gnome_print_moveto(ctx, p1->x, p1->y);
    gnome_print_curveto(ctx, p1->x, p1->y, p2->x, p2->y, p3->x, p3->y);
    /* gnome_print_closepath(ctx); */
    
    gnome_print_fill(ctx);
}
