#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# GConnections.py
#
# DESCRIPTION:
"""
"""
# NOTES:
#

__all__ = ['ConnectionTriggerObj']

from gnue.common.definitions.GObjects import GObj
from gnue.common.apps import GDebug
import types

_blockedMethods = ('connect','close','getLoginFields')

class ConnectionTriggerObj(GObj): 
  """
  Class that allows us to insert Connection objects into trigger namespaces
  """
  def __init__(self, connection, name): 
    self.name = name
    self.__connection = connection
    GObj.__init__(self, type="ConnTrigObj")
    
    self._triggerGlobal = True
    self._triggerFunctions={}
                            
    for method in dir(connection): 
      function = getattr(connection,method)
      if method[0] != '_' and method not in _blockedMethods and type(function) == types.MethodType:
        self._triggerFunctions[method] = {'function':function}
    
    self._triggerProperties={'login':  {'get':self.__getLogin}}
        
  def __getLogin(self): 
    return self.__connection.manager.getAuthenticatedUser(self.name)
    
    
def addAllConnections(connections, gobjNamespace): 
  """
  Adds all the connection names to the global trigger namespace
  """
  for name in connections.getConnectionNames(): 
    try: 
      conn = connections.getConnection(name)
    except: 
      gDebug(1,"Cannot add connection %s to trigger namespace" % name)
      continue
    gobjNamespace.constructTriggerObject(ConnectionTriggerObj(conn, name))
    
