#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# gadfly/DBdriver.py
#
# DESCRIPTION:
# Driver to provide access to data via Gadfly
#
# NOTES:
# The Gadfly notes state that it is not safe to use in a multi-user environment
# where there may be concurrent read/writes. Use at own risk :)


import string
import sys
from gnue.common.apps import GDebug
from gnue.common.datasources import GDataObjects
from gnue.common.datasources.drivers import DBSIG2

raise "This data driver has not been upgraded to the new format."


import gadfly


class Gadfly_RecordSet(DBSIG2.RecordSet):
  pass


class Gadfly_ResultSet(DBSIG2.ResultSet): 
  def __init__(self, dataObject, cursor=None, defaultValues={}, masterRecordSet=None):
    cursor.rowcount=0
    DBSIG2.ResultSet.__init__(self, dataObject, \
            cursor, defaultValues, masterRecordSet)
    self._recordSetClass = Gadfly_RecordSet
    
  def _loadNextRecord(self):
    if self._cursor:
      rs = None

      try:
        rsets = self._cursor.fetchall()
      except self._dataObject._connection._DatabaseError, err:
        raise GDataObjects.ConnectionError, err

      if rsets and len(rsets):
        for rs in(rsets):
          if rs:
            i = 0
            dict = {}
            for f in (rs):
              dict[string.lower(self._fieldNames[i])] = f
              i += 1
            self._cachedRecords.append (self._recordSetClass(parent=self, \
                                                             initialData=dict))
          else:
            return 0
        return 1
      else:
        return 0
    else:
     return 0

##### EVIL HACK
class Error(StandardError):
  """Generic Error"""

class InterfaceError(Error):
  """Interface Error"""
  
class DatabaseError(InterfaceError):
  """DB Error"""

class DataError(DatabaseError):
  """Data Error"""

class OperationalError(DatabaseError):
  """Operational Error"""
  
class IntegrityError(DatabaseError):
  """Integrity Error"""

##### END EVIL HACK

class Gadfly_DataObject(DBSIG2.DataObject):


  def __init__(self): 
    DBSIG2.DataObject.__init__(self)
    self._DatabaseError = Error
    self._resultSetClass = Gadfly_ResultSet

    # LIKE is not supported on database level at the moment
    # there should be used other ways to emulate it
    # until that works, do a = instead of a like
    # EVIL HACK
    self.conditionElements.update({\
       'like':            (2,   2, '%s = %s',             None     ),\
       'notlike':         (2,   2, 'NOT (%s = %s)',       None     )})
    # END EVIL HACK



  def connect(self, connectData={}): 
    gDebug(9,"Gadfly database driver initializing")
    #GDebug.printMesg(1,"Connecting with %s, %s" %( connectData['_dbname'], connectData['directory']))
    try:
      self._dataConnection = gadfly.gadfly(connectData['dbname'],
                                           connectData['directory'])
    except self._DatabaseError, value:
      #GDebug.printMesg(1,"Boom")
      raise GDataObjects.LoginError, value
      
    self._beginTransaction()
    self._postConnect()


  def _postConnect(self): 
    self.triggerExtensions = TriggerExtensions(self._dataConnection)


  def _beginTransaction(self):
    try:
      self._dataConnection.begin()
    except: 
      pass

  # This should be over-ridden only if driver needs more than user/pass
  def getLoginFields(self):
    return []

  #
  # Schema (metadata) functions
  #

  # Return a list of the types of Schema objects this driver provides
  def getSchemaTypes(self):
    return [('view',_('Views'),1),
            ('table',_('Tables'),1)]

  # Return a list of Schema objects
  def getSchemaList(self, type=None):

    statement = "select * from __table_names__"

    cursor = self._dataConnection.cursor()
    GDebug.printMesg(1,"** Executing: %s **" % statement)
    cursor.execute(statement)    

    list = []
    for rs in cursor.fetchall():
      # exclude any system tables and views. f.e. __table_names__
      if rs[1][:2]!="__":       
        list.append(GDataObjects.Schema(attrs={'id':rs[1], 'name':rs[1], \
                                'type':rs[0] == 1 and 'view' or 'table',},
                                       getChildSchema=self.__getFieldSchema))

    cursor.close()
    return list


  # Find a schema object with specified name
  def getSchemaByName(self, name, type=None):
    statement = "SELECT * from __table_names__ WHERE TABLE_NAME='%s'" % (name)

    cursor = self._dataConnection.cursor()
    GDebug.printMesg(1,"** Executing: %s **" % statement)
    cursor.execute(statement)

    rs = cursor.fetchone()
    if rs:
      schema = GDataObjects.Schema(attrs={'id':rs[1], 'name':rs[1], \
                                'type':rs[0] == 1 and 'view' or 'table',},
                                       getChildSchema=self.__getFieldSchema)
    else:
      schema = None

    cursor.close()
    return schema


  # Get fields for a table
  def __getFieldSchema(self, parent):

    # TODO: Read whole definitions from __DATADEFS__ and parse them
    #       to distinguish between varchar, float and integer
    
    statement = "SELECT * FROM __COLUMNS__ WHERE TABLE_NAME='%s'" % parent.id

    cursor = self._dataConnection.cursor()
    GDebug.printMesg(1,"** Executing: %s **" % statement)
    cursor.execute(statement)
    columns = cursor.description

    list = []
    for rs in cursor.fetchall():

      #nativetype = string.split(string.replace(rs[1],')',''),'(')


      attrs={'id': "%s.%s" % (parent.id, rs[0]), 'name': rs[0],
             'type':'field', 'nativetype': 'varchar',
             'required': 0}

      #if nativetype[0] in ('int','integer','bigint','mediumint',
      #                     'smallint','tinyint','float','real',
      #                     'double','decimal'):
      #  attrs['datatype']='number'
      #elif nativetype[0] in ('date','time','timestamp','datetime'):
      #  attrs['datatype']='date'
      #else:
      #  attrs['datatype']='text'

      ## MORE EVILNESS
      attrs['datatype']='text'
      ##END HACK
      
      #try:
      #  if len(nativetype) == 2:
      #    attrs['length'] = int(string.split(nativetype[1])[0])
      #except ValueError:
      #  GDebug.printMesg(1,'WARNING: mysql native type error: %s' % nativetype)

      list.append(GDataObjects.Schema(attrs=attrs))

    cursor.close()
    return list




class Gadfly_DataObject_Object(Gadfly_DataObject, \
      DBSIG2.DataObject_Object):

  def __init__(self):
    Gadfly_DataObject.__init__(self)

  def _buildQuery(self, conditions={},forDetail=None,additionalSQL=""):
    return DBSIG2.DataObject_Object._buildQuery(self, conditions,forDetail,additionalSQL)

  def _getQueryCount(self,conditions={}):
    cursor = self._dataConnection.cursor()

    cursor.execute(self._buildQueryCount(conditions))
    # GADFLY throws an error if executing COUNT(*) on an empty set
    try:
      rs = cursor.fetchone()
      return int(rs[0])
    except:
      return 0

  def _buildQueryCount(self, conditions={}):
    # GADFLY seems to hate big letter "SELECT"
    q = "select count(*) from %s%s" % (self.table, self._conditionToSQL(conditions))

    GDebug.printMesg(5,q)

    return q

class Gadfly_DataObject_SQL(Gadfly_DataObject, \
      DBSIG2.DataObject_SQL):
  def __init__(self):
    # Call DBSIG init first because Gadfly_DataObject needs to overwrite
    # some of its values
    DBSIG2.DataObject_SQL.__init__(self)
    Gadfly_DataObject.__init__(self)

  def _buildQuery(self, conditions={}):
    return DBSIG2.DataObject_SQL._buildQuery(self, conditions)



#
#  Extensions to Trigger Namespaces
#  
class TriggerExtensions: 

  def __init__(self, connection): 
    self.__connection = connection

  # Return the current date, according to database
#  def getDate(self): 
#    pass

  # Return a sequence number from sequence 'name' 
#  def getSequence(self, name): 
#    pass

  # Run the SQL statement 'statement'
#  def sql(self, statement): 
#    pass



######################################
#
#  The following hashes describe 
#  this driver's characteristings.
#
######################################

#
#  All datasouce "types" and corresponding DataObject class
# 
supportedDataObjects = {
  'object': Gadfly_DataObject_Object,
  'sql':    Gadfly_DataObject_SQL
}


