# GNU Enterprise Common - Database Drivers - Driver for MaxDB/SAP-DB
#
# Copyright 2001-2005 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: Connection.py 7007 2005-02-11 16:18:59Z reinhard $

__all__ = ['Connection']

from gnue.common.apps import errors, i18n
from gnue.common.datasources import Exceptions
from gnue.common.datasources.drivers import DBSIG2
from DataObject import *

import sapdb.dbapi

from gnue.common.datasources.drivers.sapdb.Schema.Discovery.Introspection \
    import Introspection
from gnue.common.datasources.drivers.sapdb.Schema.Creation.Creation \
    import Creation


# =============================================================================
# Connection object for MaxDB/SAP-DB backends
# =============================================================================

class Connection (DBSIG2.Connection):

  _driver            = sapdb.dbapi
  _DatabaseError     = sapdb.dbapi.DatabaseError
  _named_as_sequence = True
  defaultBehavior    = Introspection
  defaultCreator     = Creation
  _boolean_false     = False
  _boolean_true      = True
  _numbers_as_string = False

  supportedDataObjects = {
    'object': DataObject_Object,
    'sql':    DataObject_SQL
  }

  # ---------------------------------------------------------------------------
  # Connect to the database
  # ---------------------------------------------------------------------------

  def connect (self, connectData = {}):
    """
    """

    gDebug (9, "SAP database driver initializing")

    try:
      options = {'autocommit': 'off'}
      
      for gnueName, sapdbName in [('sqlmode'   , 'sqlmode'),
                                  ('timeout'   , 'timeout'),
                                  ('isolation' , 'isolation'),
                                  ('sqlsubmode', 'component')]:
        if connectData.has_key (gnueName):
          options [sapdbName] = connectData [gnueName]

      user   = connectData ['_username'].upper ()
      passwd = connectData ['_password']
      dbname = connectData ['dbname']
      host   = connectData.get ('host', '')

      self.native = sapdb.dbapi.connect (user, passwd, dbname, host, **options)

    except self._DatabaseError:
      raise Exceptions.LoginError, \
          u_("The MaxDB/SAP-DB driver returned the following error:\n%s") \
          % errors.getException () [2]
