#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# config/Connection.py
#
# DESCRIPTION:
# Implementation of dbdriver for use with configuration files
#
# NOTES:
#
# 1. every config section = one record
# 2. section name = field "_section_name" (handle it similar to a private key)
#        i.e. throw an database error, if two sections have the same name
# 3. empty records wont be written, only if you write an '""' into it
# 4. The path and filename of the config file should be provided by the
#    dbname, or a filename attribute of the <database> tag (both work).
#    The place holder '~' and '%configdir%' will be resolved.
#
# TODO:
# 1. add a restriction to edit only one section (f.e. just edit the [gnue-forms]
#    section, or [gnue-designer] section etc.
#
# HISTORY:
# 04/02/05 updated to new db driver API
# 05/02/12 updated to work with api changes (commit->connection obj.)

####                                   ####
#### IF YOU MODIFY ANY CONNECTION      ####
#### ATTRIBUTES, PLEASE UPDATE info.py ####
####                                   ####

VERSION="0.0.3"

from gnue.common.datasources.drivers.Base.Connection import Connection as BaseConnection
from gnue.common.datasources import Exceptions
from DataObject import Configfile_DataObject
from RecordSet import Configfile_Error
from gnue.common.apps import GDebug
from gnue import paths
import os, ConfigParser

class Connection(BaseConnection):

  # TODO: do we have/need Introspection?
  defaultBehavior = Configfile_Error #Introspection

  supportedDataObjects = {
    'object' : Configfile_DataObject
  }

  _DatabaseError = Configfile_Error

  def connect(self, connectData={}):
    GDebug.printMesg(9,"Configfile database driver connecting...")
    try:
      # get filename
      if connectData.has_key("filename"):
        self._filename=connectData['filename']
      elif connectData.has_key("file"):
        self._filename=connectData['file']
      else:
        self._filename=connectData['dbname']

      # compute path (home directory)
      if self._filename[0]=="~":
        self._filename=os.environ["HOME"]+self._filename[1:]

      # replace placeholder "%configdir%"
      if self._filename[0:11]=="%configdir%":
        self._filename=paths.config+self._filename[11:]

      # try to open and parse file
      self.native = ConfigParser.ConfigParser()
      file=open(self._filename)
      self.native.readfp(file)
      file.close()

      # add a fake "cursor()" function to the ConfigParser
      self.native.cursor = lambda :None

    except:
      tmsg = u_("Error opening config file %s") % self._filename
      raise Exceptions.ConnectionError, tmsg

  # no authentification required
  def getLoginFields(self):
    return []

  def commit(self): 
    GDebug.printMesg (9,"Configfile database driver: commit()")
    GDebug.printMesg (9,"Writing data to: '%s'" % self._filename )
    try:
      file=open(self._filename,"w+")
      self.native.write(file)
      file.close()
    except Exception,value:
      raise Exceptions.ConnectionError, value

  def rollback(self): 
    GDebug.printMesg (9,"Configfile database driver: rollback()")
    return
