/*
**  ExtendedTextView.h
**
**  Copyright (c) 2002, 2003
**
**  Author: Ujwal S. Sathyam <ujwal@setlurgroup.com>
**  Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _GNUMail_H_ExtendedTextView
#define _GNUMail_H_ExtendedTextView

#import <AppKit/AppKit.h>

@class EditWindowController;

@interface ExtendedTextView : NSTextView
{
  // This is a flag to let us know whether we are handling this
  // particular drag and drop operation. We are using it because
  // the prepareDragOperation and performDragOperation of the
  // parent NSTextView class return "YES" even if the parent
  // cannot handle the drag type. To make matters worse, the
  // concludeDragOperation does not have any return value.
  // This all results in the inability to test whether the
  // parent could handle the drag type properly. Is this a Cocoa
  // implementation bug?
  // Fortunately, the draggingEntered and draggingUpdated methods
  // seem to return a real status, based on which we can set this flag.
  BOOL bExtendedDragNDrop;
  NSCursor *cursor;
}

// initialization routines
- (id) init;
- (id) initWithFrame:(NSRect)frameRect;
- (id)initWithFrame:(NSRect)frameRect textContainer:(NSTextContainer *)aTextContainer;

// NSTextView
- (void) pasteAsQuoted: (id) sender;

//
// Drag and Drop methods for our text view
//
- (unsigned int) draggingEntered: (id<NSDraggingInfo>) sender;
- (unsigned int) draggingUpdated: (id<NSDraggingInfo>) sender;
- (void) draggingExited: (id<NSDraggingInfo>) sender;
- (BOOL) prepareForDragOperation: (id<NSDraggingInfo>) sender;
- (BOOL) performDragOperation: (id<NSDraggingInfo>) sender;
- (void) concludeDragOperation: (id<NSDraggingInfo>) sender;


//
//
//
- (BOOL) insertFile: (NSString *) theFilename;
- (void) updateCursorForLinks;

@end


//
// private methods
//
@interface ExtendedTextView (Private)

- (unsigned int) _checkForSupportedDragTypes:(id <NSDraggingInfo>) sender;

@end

#endif // _GNUMail_H_ExtendedTextView
