/*
**  FolderNode.m
**
**  Copyright (C) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "FolderNode.h"

#include "Constants.h"

@implementation FolderNode 

- (id) init
{
  self = [super init];

  [self setParent: nil];
  [self setName: nil];
  [self setSubscribed: NO];
  [self setChildren: nil];

  return self;
}

- (void) dealloc
{
  RELEASE(name);
  RELEASE(children);
  
  [super dealloc];
}


//
// NSCopying protocol
//
- (id) copyWithZone: (NSZone *) zone
{
  return RETAIN(self);
}


//
// access / mutation methods
//
- (NSString *) name
{
  return name;
}

- (void) setName: (NSString *) theName
{
  RETAIN(theName);
  RELEASE(name);
  name = theName;
}

- (FolderNode *) parent
{
  return parent;
}

- (void) setParent: (FolderNode *) theParent
{
  parent = theParent;
}



- (BOOL) subscribed
{
  return subscribed;
}

- (void) setSubscribed: (BOOL) theBOOL
{
  subscribed = theBOOL;
}

- (NSArray *) children
{
  return children;
}

- (void) setChildren: (NSArray *) theChildren
{
  NSMutableArray *aMutableArray;
 
  aMutableArray = [[NSMutableArray alloc] init];
  
  if ( theChildren )
    {
      int i;

      [aMutableArray addObjectsFromArray: theChildren];

      for (i = 0; i < [theChildren count]; i++)
	{
	  [[theChildren objectAtIndex: i] setParent: self];
	}
    }
  
  RELEASE(children);
  children = aMutableArray;
}

- (void) addChild: (FolderNode *) theChild
{
  [children addObject: theChild];
  [children sortUsingSelector: @selector(compare:)];
}

- (void) removeChild: (FolderNode *) theChild
{
  [children removeObject: theChild];
}

- (FolderNode *) childAtIndex: (int) theIndex
{
  return [children objectAtIndex: theIndex];
}

- (FolderNode *) childWithName: (NSString *) theName
{
  int i;

  for (i = 0; i < [children count]; i++)
    {
      FolderNode *aFolderNode;

      aFolderNode = (FolderNode *)[children objectAtIndex: i];

      if ( [theName isEqualToString: aFolderNode->name] )
	{
	  return aFolderNode;
	}
    }

  return nil;
}

- (int) childCount
{
  return [children count];
}


//
// Comparison
//
- (NSComparisonResult) compare: (FolderNode *) theFolderNode
{
  return [[self name] compare: [theFolderNode name]];
}

//
// class methods
//
+ (FolderNode *) folderNodeWithName: (NSString *) theName
                             parent: (FolderNode *) theParent
{
  FolderNode *aFolderNode;

  aFolderNode = [[FolderNode alloc] init];

  [aFolderNode setName: theName];
  [aFolderNode setParent: theParent];
  
  return AUTORELEASE(aFolderNode);
}

@end
