/*
**  GNUMail.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _GNUMail_H_GNUMail
#define _GNUMail_H_GNUMail

#import <AppKit/AppKit.h>

@class AddressBookController;
@class EditWindowController;
@class Message;
@class Task;
@class URLName;
@class MessageComposition;

@interface GNUMail : NSObject
{
  // Outlets
  IBOutlet NSMenu *drafts;
#ifdef MACOSX
  IBOutlet NSMenu *dock;
#endif
  IBOutlet NSMenu *edit;
  IBOutlet NSMenu *filters;
  IBOutlet NSMenu *find;
  IBOutlet NSMenu *incomingMailServers;
  IBOutlet NSMenu *info;
  IBOutlet NSMenu *mailbox;
  IBOutlet NSMenu *menu;
  IBOutlet NSMenu *message;
  IBOutlet NSMenu *saveAttachment;
  IBOutlet NSMenu *sendToAddressBook;
  IBOutlet NSMenu *services;
  IBOutlet NSMenu *sorting;
  IBOutlet NSMenu *textEncodings;
  IBOutlet NSMenu *view;
  IBOutlet NSMenu *windows;
  
  IBOutlet NSMenuItem *deleteOrUndelete;
  IBOutlet NSMenuItem *deliver;
  IBOutlet NSMenuItem *markAsReadOrUnread;
  IBOutlet NSMenuItem *openInNewWindow;
  IBOutlet NSMenuItem *showAllHeaders;
  IBOutlet NSMenuItem *showOrHideDeleted;
  IBOutlet NSMenuItem *showOrHideRead;
  IBOutlet NSMenuItem *enterSelection;
  IBOutlet NSMenuItem *saveInDrafts;
  IBOutlet NSMenuItem *showRawSource;
  IBOutlet NSMenuItem *threadOrUnthreadMessages;

  // Other ivars
  Message *messageUsingTextEncoding;
  NSConnection *connection;
  NSMutableArray *tasks;
  Task *currentTask;
  NSTimer *timer;

  BOOL lastCopyOpWasSuccessful;
  int counter;

#ifdef MACOSX
  // for scripting
  // instance variables for to-many relationships:
  NSMutableArray *_messageCompositions;
#endif
}

- (id) init;

//
// action methods
//
- (IBAction) applyManualFilter: (id) sender;

- (IBAction) bounceMessage: (id) sender;

- (IBAction) changeTextEncoding: (id) sender;

- (IBAction) checkForUpdates: (id) sender;

- (IBAction) close: (id) sender;

- (IBAction) compactMailbox: (id) sender;

- (IBAction) composeMessage: (id) sender;

- (IBAction) copy: (id) sender;
- (IBAction) cut: (id) sender;

- (IBAction) deleteOrUndeleteMessage: (id) sender;

- (IBAction) enterSelectionInFindPanel: (id) sender;

- (IBAction) findNext: (id) sender;
- (IBAction) findPrevious: (id) sender;

- (IBAction) forwardMessage: (id) sender;
- (IBAction) getNewMessages: (id) sender;

- (IBAction) importMailboxes: (id) sender;

- (IBAction) markMessageAsReadOrUnread: (id) sender;

- (IBAction) nextUnreadMessage: (id) sender;

#ifdef MACOSX
- (IBAction) newViewerWindow: (id) sender;
#endif

- (IBAction) openInNewWindow: (id) sender;

- (IBAction) paste: (id) sender;

- (IBAction) previousUnreadMessage: (id) sender;

- (IBAction) printMessage: (id) sender;

- (IBAction) replyAllMessage: (id) sender;
- (IBAction) replyMessage: (id) sender;

- (IBAction) restoreDraft: (id) sender;

- (IBAction) saveAllAttachments: (id) sender;
- (IBAction) saveAttachment: (id) sender;
- (IBAction) saveInDrafts: (id) sender;
- (IBAction) saveTextFromMessage: (id) sender;

- (IBAction) sortByNumber: (id) sender;
- (IBAction) sortByDate: (id) sender;
- (IBAction) sortByName: (id) sender;
- (IBAction) sortBySubject: (id) sender;
- (IBAction) sortBySize: (id) sender;

- (IBAction) showAboutPanel: (id) sender;
- (IBAction) showAddressBook: (id) sender;
- (IBAction) showAllHeaders: (id) sender;
- (IBAction) showConsoleWindow: (id) sender;
- (IBAction) showFindWindow: (id) sender;
- (IBAction) showMailboxManager: (id) sender;

- (IBAction) showOrHideDeletedMessages: (id) sender;
- (IBAction) showOrHideReadMessages: (id) sender;

- (IBAction) showPreferencesWindow: (id) sender;
- (IBAction) showRawSource: (id) sender;

- (IBAction) threadOrUnthreadMessages: (id) sender;


//
// delegate methods
//
- (BOOL) applicationShouldTerminate: (NSApplication *) theSender;

- (void) applicationWillFinishLaunching: (NSNotification *) theNotification;

- (void) applicationDidFinishLaunching: (NSNotification *) theNotification;


//
// methods invoked by notifications
//
- (void) selectionInTextViewHasChanged: (id) sender;

- (void) selectionOfMessageHasChanged: (id) sender;


//
// access / mutation methods
//
+ (NSArray *) allBundles;

+ (NSArray *) allMailWindows;

+ (NSString *) currentWorkingPath;
+ (void) setCurrentWorkingPath: (NSString *) thePath;

+ (id) lastAddressTakerWindowOnTop;
+ (void) setLastAddressTakerWindowOnTop: (id) aWindow;

+ (id) lastMailWindowOnTop;
+ (void) setLastMailWindowOnTop: (id) aWindow;

- (NSMenu *) saveAttachmentMenu;
- (NSMenuItem *) deliverMenuItem;

- (void) setEnableSaveInDraftsMenuItem: (BOOL) aBOOL;

- (void) setShowRawSourceMenuItem: (BOOL) aBOOL;

- (NSMenuItem *) showAllHeadersMenuItem;

//
// other methods
// 
- (void) addItemToMenuFromTextAttachment: (NSTextAttachment *) theTextAttachment;

+ (void) addEditWindow: (id) theEditWindow;
+ (void) addMailWindow: (id) theMailWindow;

- (void) addToAddressBook: (id) sender;

- (void) loadBundles;

- (void) removeAllItemsFromMenu: (NSMenu *) theMenu;

+ (void) removeEditWindow: (id) theEditWindow;
+ (void) removeMailWindow: (id) theMailWindow;

- (void) showFoldersToOpen;

#ifdef MACOSX
- (void) updateDockMenu;
#endif

- (void) updateFilterMenuItems: (id) sender;

- (void) updateGetNewMailMenuItems: (id) sender;

- (void) updateMenuItemsForMessage: (Message *) theMessage;

- (void) updateShowOrHideDeletedMenuItem: (BOOL) aBOOL;
- (void) updateShowOrHideReadMenuItem: (BOOL) aBOOL;

- (void) updateTextEncodingsMenu: (id) sender;

- (void) updateThreadOrUnthreadMenuItem: (BOOL) aBOOL;

- (void) newMessageWithRecipient: (NSString *) aString;



//
// services methods
//
- (void) newMessageWithContent: (NSPasteboard *) pboard
	              userData: (NSString *) userData
                         error: (NSString **) error;

- (void) newMessageWithRecipient: (NSPasteboard *) pboard
	                userData: (NSString *) userData
                           error: (NSString **) error;

@end


#ifdef MACOSX
// Scripting support; still experimental code.
@interface GNUMail (KeyValueCoding)

- (BOOL)application:(NSApplication *)sender delegateHandlesKey:(NSString *)key;
// accessors for to-many relationships:
-(NSMutableArray*)messageCompositions;
-(void)setMessageCompositions: (NSMutableArray*)messageCompositions;

- (void) addInMessageCompositions: (MessageComposition *)object;
- (void) insertInMessageCompositions: (MessageComposition *) object;
- (void) insertInMessageCompositions: (MessageComposition *) object atIndex: (unsigned) index;
- (void) replaceInMessageCompositions: (MessageComposition *) object atIndex: (unsigned) index;
- (void) removeFromMessageCompositionsAtIndex: (unsigned) index;
- (id) valueInMessageCompositionsAtIndex: (unsigned) index;

@end
#endif

//
// Private methods
//
@interface GNUMail (Private)

- (BOOL) _checkForUpdate;
- (BOOL) _checkDictionary: (NSDictionary *) theDictionary;
- (void) _newVersionAvailable: (NSString *) theVersion;
- (void) _savePanelDidEnd: (NSSavePanel *) theSheet 
               returnCode: (int) returnCode
              contextInfo: (void  *) contextInfo;

@end

#endif // _GNUMail_H_GNUMail
