#include "gnome.h"
#include "gconf/gconf-client.h"

int main(int argc, char **argv)
{
  GConfClient *client;
  gchar *name, *key;
  gint i;

  gnome_program_init("goat-create", "0.1", LIBGNOMEUI_MODULE,
                     argc, argv,
                     GNOME_PROGRAM_STANDARD_PROPERTIES, NULL);

  client = gconf_client_get_default();

  for (i=1; i<argc; i++) {

    /* active a goat */

    name = g_strdup_printf("new_goat_%i", g_random_int());
    key = g_strdup_printf("/apps/goats/herd/%s/alive", name);
    
    gconf_client_set_bool(client, key,
			  TRUE, NULL);
    g_free(key);

    /* add text */

    key = g_strdup_printf("/apps/goats/herd/%s/text", name);
    gconf_client_set_string(client, key, argv[i], NULL);

    /* make it visible */

    key = g_strdup_printf("/apps/goats/herd/%s/hidden", name);
    gconf_client_set_bool(client, key,
			  FALSE, NULL);
    g_free(key);
    g_free(name);
  }
}
