/* goats client preferences */

#include <config.h>
#include <gnome.h>
#include <glade/glade.h>
#include <gconf/gconf-client.h>

#include "goats-applet.h"
#include "goats-applet-preferences.h"

static gint prefs_delete_cb(GtkWidget *widget, GdkEvent *event, 
			    GtkWidget *window)

     /* Don't actually delete, just hide */
{
  gtk_widget_hide(window);

  return TRUE;
}

static void prefs_close_cb(GtkWidget *widget, GtkWidget *window)
{
  gtk_widget_hide(window);
}

static void prefs_help_cb(GtkWidget *widget)
{
  GError *err;

  err = NULL;
  gnome_help_display ("goats", "goats-customize",
                      &err);

  if (err) {
    goats_error("show_help_cb", err->message);
    g_error_free(err);
  }
}

static void default_height_changed_cb(GtkWidget *widget, 
				      GoatsApplet *goats)
{
  gint size;

  size = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
  gconf_client_set_int(goats->gconf_client,
		       "/apps/goats/defaults/height",
		       size, NULL);
}

static void default_width_changed_cb(GtkWidget *widget, 
				     GoatsApplet *goats)
{
  gint size;

  size = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
  gconf_client_set_int(goats->gconf_client,
		       "/apps/goats/defaults/width",
		       size, NULL);
}

static void default_colour_changed_cb(GtkWidget *widget,
				      GoatsApplet *goats)
{
  GtkWidget *w;

  w = glade_xml_get_widget(goats->prefs_xml, "colour_menu");
  gconf_client_set_int
  (goats->gconf_client,
     "/apps/goats/defaults/bg",
     gtk_option_menu_get_history(GTK_OPTION_MENU(w)),
     NULL);
}

static void default_font_set_cb(GtkWidget *widget,
				gchar *arg,
				GoatsApplet *goats)
{
  gconf_client_set_string
    (goats->gconf_client,
     "/apps/goats/defaults/font_name", arg, NULL);
}

static void default_sound_toggled_cb(GtkWidget *widget,
				     GoatsApplet *goats)
{
  GtkWidget *w;
  gboolean active;

  active = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));

  gconf_client_set_bool
    (goats->gconf_client,
     "/apps/goats/defaults/use_alarm_sound",
     active, NULL);
  
  w = glade_xml_get_widget(goats->prefs_xml, 
			   "default_sound_file_picker");
  gtk_widget_set_sensitive(w, active);
}

static void default_sound_file_changed_cb(GtkWidget *widget,
					  GoatsApplet *goats)
{
  gconf_client_set_string
    (goats->gconf_client,
     "/apps/goats/defaults/alarm_sound_filename",
     gtk_entry_get_text(GTK_ENTRY(widget)),
     NULL);
}

static void fortune_changed_cb(GtkWidget *widget,
			       GoatsApplet *goats)
{
  gconf_client_set_string
    (goats->gconf_client,
     "/apps/goats/settings/fortune",
     gtk_entry_get_text(GTK_ENTRY(widget)),
     NULL);
}

static void cal_changed_cb(GtkWidget *widget,
			   GoatsApplet *goats)
{
  gconf_client_set_string
    (goats->gconf_client,
     "/apps/goats/settings/cal",
     gtk_entry_get_text(GTK_ENTRY(widget)),
     NULL);
}

static void date_changed_cb(GtkWidget *widget,
			    GoatsApplet *goats)
{
  gconf_client_set_string
    (goats->gconf_client,
     "/apps/goats/settings/date",
     gtk_entry_get_text(GTK_ENTRY(widget)),
     NULL);
}

static void default_sticky_toggled_cb(GtkWidget *widget,
				      GoatsApplet *goats)
{
  gconf_client_set_bool
    (goats->gconf_client,
     "/apps/goats/defaults/sticky",
     gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)),
     NULL);
}

static void default_fg_set_cb(GtkWidget *widget,
			      guint r,
			      guint g,
			      guint b,
			      guint a,
			      GoatsApplet *goats)
{
  gconf_client_set_int(goats->gconf_client,
		       "/apps/goats/defaults/fg_r",
		       r, NULL);
  gconf_client_set_int(goats->gconf_client,
		       "/apps/goats/defaults/fg_g",
		       g, NULL);
  gconf_client_set_int(goats->gconf_client,
		       "/apps/goats/defaults/fg_b",
		       b, NULL);
}

static void delete_menu_changed_cb(GtkWidget *widget, GoatsApplet *goats)
{
  gboolean delete_hides;
  GtkWidget *w;

  w = glade_xml_get_widget(goats->prefs_xml, "delete_menu");
  if (gtk_option_menu_get_history(GTK_OPTION_MENU(w)) == 0)
    delete_hides = FALSE;
  else
    delete_hides = TRUE;
  gconf_client_set_bool
    (goats->gconf_client,
     "/apps/goats/settings/delete_hides", delete_hides,
     NULL);
}

static gint customize_delete_cb(GtkWidget *widget, GdkEvent *event,
				GladeXML *xml)
{
  g_object_unref(G_OBJECT(xml));

  return FALSE;
}

static void customize_close_cb(GtkWidget *widget, GtkWidget *window)
{
  gtk_widget_destroy(window);
}

static void customize_unref_cb(GtkWidget *widget, GladeXML *xml)
{
  g_object_unref(G_OBJECT(xml));
}

static void colour_1_set_cb(GtkWidget *widget,
			    guint r,
			    guint g,
			    guint b,
			    guint a,
			    GoatsApplet *goats)
{
  gconf_client_set_int(goats->gconf_client,
		       "/apps/goats/defaults/bg1_r",
		       r, NULL);
  gconf_client_set_int(goats->gconf_client,
		       "/apps/goats/defaults/bg1_g",
		       g, NULL);
  gconf_client_set_int(goats->gconf_client,
		       "/apps/goats/defaults/bg1_b",
		       b, NULL);
}

static void colour_2_set_cb(GtkWidget *widget,
			    guint r,
			    guint g,
			    guint b,
			    guint a,
			    GoatsApplet *goats)
{
  gconf_client_set_int(goats->gconf_client,
		       "/apps/goats/defaults/bg2_r",
		       r, NULL);
  gconf_client_set_int(goats->gconf_client,
		       "/apps/goats/defaults/bg2_g",
		       g, NULL);
  gconf_client_set_int(goats->gconf_client,
		       "/apps/goats/defaults/bg2_b",
		       b, NULL);
}

static void colour_3_set_cb(GtkWidget *widget,
			    guint r,
			    guint g,
			    guint b,
			    guint a,
			    GoatsApplet *goats)
{
  gconf_client_set_int(goats->gconf_client,
		       "/apps/goats/defaults/bg3_r",
		       r, NULL);
  gconf_client_set_int(goats->gconf_client,
		       "/apps/goats/defaults/bg3_g",
		       g, NULL);
  gconf_client_set_int(goats->gconf_client,
		       "/apps/goats/defaults/bg3_b",
		       b, NULL);
}

static void customize_clicked_cb(GtkWidget *widget, GoatsApplet *goats)
{
  GtkWidget *w, *window;
  GladeXML *xml;

  xml = glade_xml_new(goats->xml_file, "customize_colours", NULL);
  window = glade_xml_get_widget(xml, "customize_colours");
  gtk_widget_show(window);
  g_signal_connect(G_OBJECT(window), "delete_event", 
		   G_CALLBACK(customize_delete_cb) ,
		   xml);
  w = glade_xml_get_widget(xml, "customize_close");
  g_signal_connect(G_OBJECT(w), "clicked", 
		   G_CALLBACK(customize_unref_cb),
		   xml);
  w = glade_xml_get_widget(xml, "customize_close");
  g_signal_connect(G_OBJECT(w), "clicked", 
		   G_CALLBACK(customize_close_cb),
		   window);

  w = glade_xml_get_widget(xml, "custom_picker_1");
  gnome_color_picker_set_i16(GNOME_COLOR_PICKER(w),
			     gconf_client_get_int
			     (goats->gconf_client,
			      "/apps/goats/defaults/bg1_r", NULL),
			     gconf_client_get_int
			     (goats->gconf_client,
			      "/apps/goats/defaults/bg1_g", NULL),
			     gconf_client_get_int
			     (goats->gconf_client,
			      "/apps/goats/defaults/bg1_b", NULL),
			     65535);
  g_signal_connect(G_OBJECT(w), "color_set", 
		     G_CALLBACK(colour_1_set_cb),
		     goats);

  w = glade_xml_get_widget(xml, "custom_picker_2");
  gnome_color_picker_set_i16(GNOME_COLOR_PICKER(w),
			     gconf_client_get_int
			     (goats->gconf_client,
			      "/apps/goats/defaults/bg2_r", NULL),
			     gconf_client_get_int
			     (goats->gconf_client,
			      "/apps/goats/defaults/bg2_g", NULL),
			     gconf_client_get_int
			     (goats->gconf_client,
			      "/apps/goats/defaults/bg2_b", NULL),
			     65535);
  g_signal_connect(G_OBJECT(w), "color_set", 
		     G_CALLBACK(colour_2_set_cb),
		     goats);
  w = glade_xml_get_widget(xml, "custom_picker_3");
  gnome_color_picker_set_i16(GNOME_COLOR_PICKER(w),
			     gconf_client_get_int
			     (goats->gconf_client,
			      "/apps/goats/defaults/bg3_r", NULL),
			     gconf_client_get_int
			     (goats->gconf_client,
			      "/apps/goats/defaults/bg3_g", NULL),
			     gconf_client_get_int
			     (goats->gconf_client,
			      "/apps/goats/defaults/bg3_b", NULL),
			     65535);
  g_signal_connect(G_OBJECT(w), "color_set", 
		     G_CALLBACK(colour_3_set_cb),
		     goats);
}

void goats_client_preferences_update_swatches(GoatsApplet *goats)
{
  GdkPixbuf *pixbuf;
  GtkWidget *w;
  guchar *pixels;
  gint rowstride, row, pixel, red, green, blue, height, width, i;
  gchar *key;

  for (i=0; i<3; i++) {
    pixbuf = goats->bg_swatches[i];
    pixels = gdk_pixbuf_get_pixels(pixbuf);
    rowstride = gdk_pixbuf_get_rowstride(pixbuf);
    height = gdk_pixbuf_get_height(pixbuf);
    width = gdk_pixbuf_get_width(pixbuf);
    key = g_strdup_printf("/apps/goats/defaults/bg%i_r", i+1);
    red = gconf_client_get_int(goats->gconf_client, 
			       key, NULL) / 256;
    g_free(key);
    key = g_strdup_printf("/apps/goats/defaults/bg%i_g", i+1);
    green = gconf_client_get_int(goats->gconf_client,
				 key, NULL) / 256;
    g_free(key);
    key = g_strdup_printf("/apps/goats/defaults/bg%i_b", i+1);
    blue = gconf_client_get_int(goats->gconf_client,
				key, NULL) / 256;
    g_free(key);
    for (row=0; row<height; row++) {
      for (pixel=0; pixel<width; pixel++) {
	pixels[row*rowstride + pixel*3] = red;
	pixels[row*rowstride + pixel*3 + 1] = green;
	pixels[row*rowstride + pixel*3 + 2] = blue;
      }
    }
  }
  /* FIXME pixbuf is not updated on screen until expose etc 
     this is a hack to force the swatch to update*/
  w = glade_xml_get_widget(goats->prefs_xml, "colour_menu");
  i =  gconf_client_get_int(goats->gconf_client,
			    "/apps/goats/defaults/bg",
			    NULL);
  gtk_option_menu_set_history(GTK_OPTION_MENU(w), 3-i);
  gtk_option_menu_set_history(GTK_OPTION_MENU(w), i);  
}

void goats_client_preferences_init(GoatsApplet *goats)
{
  GtkWidget *w, *menu, *item, *swatch, *window;
  gchar *text;
  gint history, i;

  goats->prefs_xml = glade_xml_new(goats->xml_file, 
				   "preferences", NULL);

  window = glade_xml_get_widget(goats->prefs_xml, "preferences");
  gtk_window_set_icon(GTK_WINDOW(window), goats->pixbuf_lit);

  g_signal_connect(G_OBJECT(window), "delete_event",
		   G_CALLBACK(prefs_delete_cb),
		   window);
  w = glade_xml_get_widget(goats->prefs_xml, "close");
  g_signal_connect(G_OBJECT(w), "clicked",
		   G_CALLBACK(prefs_close_cb),
		   window);
  w = glade_xml_get_widget(goats->prefs_xml, "help");
  g_signal_connect(G_OBJECT(w), "clicked",
		   G_CALLBACK(prefs_help_cb),
                   NULL);

  w = glade_xml_get_widget(goats->prefs_xml, "default_height_spin");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(w), 
			    gconf_client_get_int(goats->gconf_client,
						 "/apps/goats/defaults/height",
						 NULL));
  g_signal_connect(G_OBJECT(w), "changed",
		     G_CALLBACK(default_height_changed_cb),
		     goats);
  w = glade_xml_get_widget(goats->prefs_xml, "default_width_spin");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(w), 
			    gconf_client_get_int(goats->gconf_client,
						 "/apps/goats/defaults/width",
						 NULL));
  g_signal_connect(G_OBJECT(w), "changed",
		     G_CALLBACK(default_width_changed_cb),
		     goats);

  w = glade_xml_get_widget(goats->prefs_xml, "colour_menu");
  menu = gtk_option_menu_get_menu(GTK_OPTION_MENU(w));
  for (i=2; i>=0; i--) {
    item = gtk_menu_item_new();
    goats->bg_swatches[i] = gdk_pixbuf_new(GDK_COLORSPACE_RGB, FALSE,
					   8, 16, 16);
    swatch = gtk_image_new_from_pixbuf(goats->bg_swatches[i]);
    gtk_container_add(GTK_CONTAINER(item), 
		      swatch);
    gtk_widget_show_all(item);
    gtk_menu_shell_prepend(GTK_MENU_SHELL(menu), item);
  }
  goats_client_preferences_update_swatches(goats);
  gtk_option_menu_set_history(GTK_OPTION_MENU(w), 
			      gconf_client_get_int(goats->gconf_client,
						   "/apps/goats/defaults/bg",
						   NULL));
  g_signal_connect(G_OBJECT(gtk_option_menu_get_menu(GTK_OPTION_MENU(w))), 
		     "selection_done",
		     G_CALLBACK(default_colour_changed_cb),
		     goats);

  w = glade_xml_get_widget(goats->prefs_xml, "customize_button");
  g_signal_connect(G_OBJECT(w), "clicked",
		     G_CALLBACK(customize_clicked_cb),
		     goats);

  w = glade_xml_get_widget(goats->prefs_xml, "default_font_picker");
  /* FIXME initial value */
  g_signal_connect(G_OBJECT(w), "font_set",
		     G_CALLBACK(default_font_set_cb),
		     goats);

  w = glade_xml_get_widget(goats->prefs_xml, 
			   "default_sound_checkbutton");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), 
			       gconf_client_get_bool(goats->gconf_client,
						     "/apps/goats/defaults/use_alarm_sound",
						     NULL));
  g_signal_connect(G_OBJECT(w), "toggled",
		     G_CALLBACK(default_sound_toggled_cb),
		     goats);

  w = glade_xml_get_widget(goats->prefs_xml, 
			   "default_sound_file_picker");
  text = gconf_client_get_string(goats->gconf_client,
				 "/apps/goats/defaults/alarm_sound_filename",
				 NULL);
  gtk_entry_set_text(GTK_ENTRY(gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(w))),
		     text);
  g_free(text);
  g_signal_connect(G_OBJECT(gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(w))),
		     "changed",
		     G_CALLBACK(default_sound_file_changed_cb),
		     goats);

  w = glade_xml_get_widget(goats->prefs_xml, 
			   "default_sticky_checkbutton");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), 
			       gconf_client_get_bool(goats->gconf_client,
						     "/apps/goats/defaults/sticky",
						     NULL));
  g_signal_connect(G_OBJECT(w), "toggled",
		     G_CALLBACK(default_sticky_toggled_cb),
		     goats);

  w = glade_xml_get_widget(goats->prefs_xml, 
			   "default_colour_picker");
  gnome_color_picker_set_i16(GNOME_COLOR_PICKER(w),
			     gconf_client_get_int
			     (goats->gconf_client,
			      "/apps/goats/defaults/fg_r", NULL),
			     gconf_client_get_int
			     (goats->gconf_client,
			      "/apps/goats/defaults/fg_g", NULL),
			     gconf_client_get_int
			     (goats->gconf_client,
			      "/apps/goats/defaults/fg_b", NULL),
			     65535);
  g_signal_connect(G_OBJECT(w), "color-set",
		     G_CALLBACK(default_fg_set_cb),
		     goats);

  w = glade_xml_get_widget(goats->prefs_xml, "delete_menu");
  if (gconf_client_get_bool(goats->gconf_client,
			    "/apps/goats/settings/delete_hides",
			    NULL)) history = 1;
  else history = 0;
  gtk_option_menu_set_history(GTK_OPTION_MENU(w), history);
  g_signal_connect(G_OBJECT(gtk_option_menu_get_menu(GTK_OPTION_MENU(w))), 
		     "selection_done",
		     G_CALLBACK(delete_menu_changed_cb),
		     goats);

  w = glade_xml_get_widget(goats->prefs_xml, "fortune_command_entry");
  text = gconf_client_get_string(goats->gconf_client,
				 "/apps/goats/settings/fortune",
				 NULL);
  gtk_entry_set_text(GTK_ENTRY(w), text);
  g_free(text);
  g_signal_connect(G_OBJECT(w), "changed",
		   G_CALLBACK(fortune_changed_cb), goats);

  w = glade_xml_get_widget(goats->prefs_xml, "calendar_command_entry");
  text = gconf_client_get_string(goats->gconf_client,
				 "/apps/goats/settings/cal",
				 NULL);
  gtk_entry_set_text(GTK_ENTRY(w), text);
  g_free(text);
  g_signal_connect(G_OBJECT(w), "changed",
		   G_CALLBACK(cal_changed_cb), goats);

  w = glade_xml_get_widget(goats->prefs_xml, "date_command_entry");
  text = gconf_client_get_string(goats->gconf_client,
				 "/apps/goats/settings/date",
				 NULL);
  gtk_entry_set_text(GTK_ENTRY(w), text);
  g_free(text);
  g_signal_connect(G_OBJECT(w), "changed",
		   G_CALLBACK(date_changed_cb), goats);
}
