#include <config.h> 
#include <gnome.h>

void goats_error(const gchar *function,
		 const gchar *error)

     /* general error dialog */
{
  GtkWidget *dialog;

  dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL,
				   GTK_MESSAGE_ERROR,
				   GTK_BUTTONS_OK,
				   _("Goats: an error occured in function %s.\nThe error was \"%s\"."),
				   function, error);
  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
}

void goats_warning(const gchar *function,
		   const gchar *warning)

     /* general warning dialog */
{
  GtkWidget *dialog;

  dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL,
				   GTK_MESSAGE_WARNING,
				   GTK_BUTTONS_OK,
				   _("Goats: an warning occured in function %s.\nThe error was \"%s\"."),
				   function, warning);
  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
}

void goats_message(const gchar *message)
{
  GtkWidget *dialog;

  dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL,
				   GTK_MESSAGE_INFO,
				   GTK_BUTTONS_OK,
				   message);
  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
}

gboolean goats_confirm(const gchar *message, gchar *button)
{
  GtkWidget *dialog;
  GtkResponseType response;

  dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL,
				   GTK_MESSAGE_WARNING,
				   GTK_BUTTONS_CANCEL,
				   message);
  gtk_dialog_add_button(GTK_DIALOG(dialog), button,
			GTK_RESPONSE_ACCEPT);

  response = gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);

  if (response == GTK_RESPONSE_ACCEPT) return TRUE;
  else return FALSE;
}
