#!/bin/sh

# generate Makefile.am from the directory contents

echo "## This file was automatically generated by Makefile.sh" > Makefile.am
echo >> Makefile.am
echo "pkgdatadir = @GPUTILS_HEADER_PATH@" >> Makefile.am
echo >> Makefile.am
echo "HEADER_FILES =\\" >> Makefile.am

# compile the header check program
rm -f header_check
gcc -Wall -pedantic -g -O2 -I../include -o header_check header_check.c

# count the number of items in the list
let count=0
for x in `ls *.inc | sort`
  do
    let count=count+1
  done

# output the file list
let pass=0
for x in `ls *.inc | sort`
  do
    let pass=pass+1
    echo "testing $x"
    ./header_check $x
    if [ $pass -eq $count ]; then
      echo "	$x" >> Makefile.am
    else
      echo "	$x \\" >> Makefile.am
    fi
  done
 
echo >> Makefile.am
echo "pkgdata_DATA = \$(HEADER_FILES)" >> Makefile.am
echo >> Makefile.am
echo "EXTRA_DIST = \$(HEADER_FILES) Makefile.sh header_check.c" >> Makefile.am

# clean up the temporary files
rm -f header_check
