/* $Id: emitGraph.h,v 1.11 2005/04/05 12:02:55 ellson Exp $ $Revision: 1.11 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

#include "common/Dynagraph.h"
#include "common/parsestr.h"

void emitAttrs(std::ostream &os,const StrAttrs &attrs,const DString &id=DString());

template<typename G>
void emitGraph(std::ostream &os,G *g) {
  os << "digraph " << mquote(gd<Name>(g));
  os << " {" << endl << "\tgraph ";
  emitAttrs(os,gd<StrAttrs>(g));
  for(typename G::node_iter ni = g->nodes().begin(); ni!=g->nodes().end(); ++ni) {
    os << '\t' << mquote(gd<Name>(*ni)) << ' ';
    emitAttrs(os,gd<StrAttrs>(*ni));
  }
  for(typename G::graphedge_iter ei = g->edges().begin(); ei!=g->edges().end(); ++ei) {
    os << '\t' << mquote(gd<Name>((*ei)->tail)) << " -> " << mquote(gd<Name>((*ei)->head));
    os << ' ';
    emitAttrs(os,gd<StrAttrs>(*ei),gd<Name>(*ei));
  }
  os << "}\n";
}

// try to substitute labels for names to make dotfile more pleasant
template<typename G>
void emitGraph2(std::ostream &os,G *g) {
	typedef std::map<DString,typename G::Node*> node_dict;
	typedef std::map<typename G::Node*,DString> node_reverse_dict;
	typedef std::map<DString,typename G::Edge*> edge_dict;
	node_dict ndict;
	node_reverse_dict nameOf;
	StrAttrs::iterator ati = gd<StrAttrs>(g).find("label");
	Name &gname = (ati!=gd<StrAttrs>(g).end())?ati->second:gd<Name>(g);

	os << "digraph " << mquote(gname);
	os << " {" << endl << "\tgraph ";
	emitAttrs(os,gd<StrAttrs>(g));
	for(typename G::node_iter ni = g->nodes().begin(); ni!=g->nodes().end(); ++ni) {
		StrAttrs::iterator ati = gd<StrAttrs>(*ni).find("label");
		Name nname;
		if(ati!=gd<StrAttrs>(*ni).end()&&!ndict[ati->second]) {
			ndict[ati->second] = *ni;
			nameOf[*ni] = ati->second;
			nname = ati->second;
		}
		else 
			ndict[nameOf[*ni] = nname = gd<Name>(*ni)] = *ni;
		os << '\t' << mquote(nname) << ' ';
		emitAttrs(os,gd<StrAttrs>(*ni));
	}
	edge_dict edict;
	for(typename G::graphedge_iter ei = g->edges().begin(); ei!=g->edges().end(); ++ei) {
		os << '\t' << mquote(nameOf[(*ei)->tail]) << " -> " << mquote(nameOf[(*ei)->head]);
		os << ' ';
		StrAttrs::iterator ati = gd<StrAttrs>(*ei).find("label");
		Name ename;
		if(ati!=gd<StrAttrs>(*ei).end()&&!ndict[ati->second]) {
			edict[ati->second] = *ei;
			ename = ati->second;
		}
		else
			edict[ename = gd<Name>(*ei)] = *ei;
		emitAttrs(os,gd<StrAttrs>(*ei),ename);
	}
	os << "}\n";
}
