/* $Id: weightedMedian.h,v 1.6 2005/04/05 12:02:55 ellson Exp $ $Revision: 1.6 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

typedef std::vector<double> doubV;

template<typename T>
inline T weightedMedian(std::vector<T> &vec) {
	int n = vec.size();
	T m;
	switch(n) {
	case 0:	
		m = T(0.0); 
		abort(); 
		break;
	case 1: 
		m = vec[0]; 
		break;
	case 2: 
		m = (vec[0] + vec[1]) / 2.0; 
		break;
	default:	/* weighted median */
		std::sort(vec.begin(),vec.end());
		if(n % 2) 
			m = vec[n / 2];
		else {
			int rm = n / 2,
				lm = rm - 1;
			T rspan = vec[n - 1] - vec[rm],
				lspan = vec[lm] - vec[0];
			if(lspan == rspan)
				m = (vec[lm] + vec[rm]) / T(2.0);
			else {
				T w = vec[lm]*rspan + vec[rm]*lspan;
				m = w / (lspan + rspan);
			}
		}
		break;
	}
	return m;
}
