/*****************************************************************************
*
* MODULE:       OGR driver 
*   	    	
* AUTHOR(S):    Radim Blazek
*
* PURPOSE:      DB driver for OGR sources     
*
* COPYRIGHT:    (C) 2004 by the GRASS Development Team
*
*               This program is free software under the GNU General Public
*   	    	License (>=v2). Read the file COPYING that comes with GRASS
*   	    	for details.
*
*****************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <gis.h>
#include <dbmi.h>
#include "ogr_api.h"
#include "globals.h"
#include "proto.h"

/* init error message */
void
init_error ( void )
{
    if ( !errMsg ) {
	errMsg = (dbString *) G_malloc(sizeof(dbString));
        db_init_string (errMsg);
    }

    db_set_string ( errMsg, "DBMI-OGR driver error:\n");
}

/* append error message */
void
append_error ( const char *fmt, ...)
{
    FILE *fp = NULL;
    char *work = NULL;
    int count = 0;
    va_list ap;

    va_start (ap, fmt);
    if ((fp = tmpfile())) {
        count = vfprintf (fp, fmt, ap);
        if (count >= 0 && (work = calloc(count+1,1)) ) {
	    rewind (fp);
	    fread (work, 1, count, fp);
	    db_append_string ( errMsg, work);
	    free (work);
        }
        fclose (fp);
    }
    va_end (ap);
}

void
report_error ( void )
{
    db_append_string ( errMsg, "\n");
    db_error ( db_get_string (errMsg) );
}

