/*
 * $Id: gprojects.h,v 1.5 2004/01/26 15:37:12 paul Exp $
 *
 ******************************************************************************
 *
 * MODULE:       gproj library
 * AUTHOR(S):    Original Author unknown, probably Soil Conservation Service
 *               Paul Kelly
 * PURPOSE:      Include file for GRASS modules that use the PROJ.4
 *               wrapper functions
 * COPYRIGHT:    (C) 2003 by the GRASS Development Team
 *
 *               This program is free software under the GNU General Public
 *               License (>=v2). Read the file COPYING that comes with GRASS
 *               for details.
 *
 *****************************************************************************/

#include "config.h"
#include <proj_api.h>
#ifdef HAVE_OGR
#    include <ogr_srs_api.h>
#endif

/* Data Files */
#define ELLIPSOIDTABLE "/etc/ellipse.table"
#define DATUMTABLE "/etc/datum.table"
#define DATUMTRANSFORMTABLE "/etc/datumtransform.table"

struct pj_info {
      projPJ     *pj;
      double meters;
      int    zone;
      char   proj[100];
};

struct gpj_datum
{
    char *name, *longname, *ellps;
    double dx, dy, dz;
};

struct gpj_ellps
{
    char *name, *longname;
    double a, es, rf;
};

/* do_proj.c */
int pj_do_proj (double *, double *, struct pj_info *, struct pj_info *);
int pj_do_transform (int, double *, double *, double *, 
                           struct pj_info *, struct pj_info *);

/* get_proj.c */
int pj_get_kv (struct pj_info *, struct Key_Value *, struct Key_Value *);
int pj_get_string (struct pj_info *, char *);
int GPJ_get_equivalent_latlong (struct pj_info *, struct pj_info *);
const char * set_proj_lib (const char *);
int pj_print_proj_params (struct pj_info *, struct pj_info *);

/* convert.c */
#ifdef HAVE_OGR
char * GPJ_grass_to_wkt (struct Key_Value *, 
			       struct Key_Value *, int, int );
OGRSpatialReferenceH * GPJ_grass_to_osr (struct Key_Value *, 
                                               struct Key_Value * );
int GPJ_wkt_to_grass(struct Cell_head *, struct Key_Value **,
                     struct Key_Value **, const char *, int);
int GPJ_osr_to_grass(struct Cell_head *, struct Key_Value **,
                     struct Key_Value **, OGRSpatialReferenceH *, int);
const char *GPJ_set_csv_loc(const char *);
#endif

/* datum.c */
int GPJ_get_datum_by_name (const char *, struct gpj_datum *);
int GPJ_get_default_datum_params_by_name(const char *, char **);
int GPJ_get_datum_params (char **, char **);
int GPJ__get_datum_params (struct Key_Value *, char **, char **);
void GPJ_free_datum (struct gpj_datum *);
int GPJ_ask_datum_params(char *, char **);
  
/* ellipse.c */
int GPJ_get_ellipsoid_by_name (const char *, struct gpj_ellps *);
int GPJ_get_ellipsoid_params (double *, double *, double *);
int GPJ__get_ellipsoid_params (struct Key_Value *, 
				    double *, double *, double *);
void GPJ_free_ellps (struct gpj_ellps *);

