/*
 * Invisible window header
 *
 * Create invisible window over the root window
 * to detect mouse button push on GroMove.
 * I make it the lowest window for the least effects.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GRO_INVISWIN_H__
#define __GRO_INVISWIN_H__

#include <gtk/gtkinvisible.h>
#include "growin.h"

/** Library private **/
#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Data structure definitions */	
typedef struct _InvisWin InvisWin;
struct _InvisWin {
	GtkInvisible *invis_w;
};

/* Global function declarations */
extern InvisWin* invis_win_new(const GroWindow *gro_win);
extern void invis_win_delete(InvisWin *invis);
extern void invis_win_show(InvisWin *invis);
extern void invis_win_hide(InvisWin *invis);
	
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GRO_INVISWIN_H__ */
