#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "prefs.h"

void io_read_card(GtkWidget *button, gpointer user_data);
void io_write_card(GtkWidget *button, gpointer user_data);


void io_read_card(GtkWidget *button, gpointer user_data) {

  char card_info[1024];
  char card_content[1024];
  char smartcard_command[128];
  FILE *smartcard;
  int count;
  
  gtk_editable_delete_text(GTK_EDITABLE(lookup_widget(GTK_WIDGET(button),
						      "card_info")),
			   0, -1);
  
  /* construct the command line to read info/ATR */
  sprintf(smartcard_command, "smartcard -i --port=%d --force-atr",
	  atoi(prefs_get_value("reader_com_port")) - 1);

  /* get reader/card info and ATR */
  smartcard = popen(smartcard_command, "r");
  while((count = fread(card_info, sizeof(char), sizeof(card_info), smartcard))) {
    gtk_text_insert(GTK_TEXT(lookup_widget(GTK_WIDGET(button), "card_info")),
		    NULL, NULL, NULL, card_info, count);
  }

  fclose(smartcard);
  
  gtk_editable_delete_text(GTK_EDITABLE(lookup_widget(GTK_WIDGET(button),
						    "card_content")),
			 0, -1);
 
  /* construct command line to read data from the card*/

  sprintf(smartcard_command, "smartcard -r --port=%d %s",
	  atoi(prefs_get_value("reader_com_port")) - 1,
	  (strcmp(prefs_get_value("display"), "hex") == 0) ?
	  "| od -v -t x2 -A x " : ""); /* filter through "od" to get a hexdump */
  
  smartcard = popen(smartcard_command, "r");

  while((count = fread(card_info, sizeof(char), sizeof(card_content), smartcard))) {
    gtk_text_insert(GTK_TEXT(lookup_widget(GTK_WIDGET(button), "card_content")),
		    NULL, NULL, NULL, card_info, count);
  }

  fclose(smartcard);

  gnome_appbar_set_status(GNOME_APPBAR(lookup_widget(GTK_WIDGET(button),
						      "appbar1")),
			   "Reading card finished");
}


void io_write_card(GtkWidget *button, gpointer user_data)
{
  gchar *card_write;
  FILE *smartcard;
  char smartcard_command[128];
  
  card_write = gtk_editable_get_chars(GTK_EDITABLE(lookup_widget(GTK_WIDGET(button),
								 "card_content")),
				      0, -1);

  /*construct the command line to write data */
  sprintf(smartcard_command, "smartcard -w --port=%d",
	  atoi(prefs_get_value("reader_com_port")) - 1);

  smartcard = popen(smartcard_command, "w");
  fwrite(card_write, sizeof(char), strlen(card_write), smartcard);
  fclose(smartcard);

  gnome_appbar_set_status(GNOME_APPBAR(lookup_widget(GTK_WIDGET(button),
						      "appbar1")),
			   "Writing card finished");
}
