/*
 * Copyright (C) 1996, 1997 Eric M. Ludlam
 * Copyright (C) 1997 Free Software Foundation
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can either send email to this
 * program's author (see below) or write to:
 * 
 *              The Free Software Foundation, Inc.
 *              675 Mass Ave.
 *              Cambridge, MA 02139, USA. 
 * 
 * Please send bug reports, etc. to zappo@gnu.org.
 * 
 * $Log: gtproc.h,v $
 * Revision 1.6  1997/12/14 19:18:23  zappo
 * Renamed package to gtalk, renamed symbols and files apropriately
 * Fixed copyright and email address.
 *
 * Revision 1.5  1997/07/22 13:23:13  zappo
 * Changed to use the list library.
 *
 * Revision 1.4  1997/01/28 03:22:49  zappo
 * Prototype maintenance
 *
 * Revision 1.3  1997/01/26  15:33:22  zappo
 * Fixed parameters to FORK_save_pid.
 *
 * Revision 1.2  1996/02/26  00:16:51  zappo
 * Updated some prototypes
 *
 * Revision 1.1  1996/02/01  02:47:38  zappo
 * Initial revision
 *
 * History:
 * zappo   1/21/96    Created
 */


#ifndef GTPROC_H
#define GTPROC_H

/* Structures:: */
/* The ASSOC node associates a substring (like a file extension) with
   an application used to view that file */
struct assoc_node {
  struct GenericListNode link;	   /* Linked list parts */
  char                  *match;	   /* string to match   */
  char                  *app_exec; /* app to run        */
};

/* The SHAPP node defines how to start different applications which now
   how to be shared between users.  This info is needed for
   verification between hosts */
struct shapp_node {
  struct GenericListNode link;          /* Linked list parts                 */
  char                  *name;		/* the shared name                   */
  char                  *commandline;	/* command line to start with tokens */
  unsigned char          proxy;		/* proxy method                      */
  unsigned char          dispreq;	/* display requirements              */
  char                   *trapkeys;	/* trapable keys                     */
};

/* These two structs let us collect differnt ways of defining
 * an application into one place */
enum app_def_type { APP_ASSOC, APP_SHAPP };

union app_def {
  struct assoc_node *assoc;	/* association part */
  struct shapp_node *shapp;	/* shared app part */
};

/* Prototypes:: */
#ifdef PROTOTYPES
/* gt_forkap.c */
extern int FORK_pid_number();
extern void FORK_pid_print(struct TalkContext *Ctxt);
extern int FORK_try(struct TalkContext *Ctxt, char *execstring, char *parameter, struct InputDevice *io, int   inp, int   outp);
extern void FORK_nuke_child_processes(struct TalkContext *Ctxt);
extern int FORK_kill_children(struct TalkContext *Ctxt);
extern int FORK_grabkey(struct TalkContext *Ctxt, char ch, struct UserObject *uo);
extern void FORK_save_pid(pid_t pid, enum app_def_type type, union app_def app, char *opt, struct UserObject *pipes);

/* gt_shapp.c */
extern int SHAPP_add(struct TalkContext *Ctxt, char *alias, char *command, int   proxy, int   dispreq);
extern int SHAPP_verify(char *alias, int   proxy, int   dispreq);
extern int SHAPP_number();
extern void SHAPP_print(struct TalkContext *Ctxt);
extern int SHAPP_fork_shared(struct TalkContext *Ctxt, char *alias, struct UserObject *uo);
extern int SHAPP_fork_shared_unsolicited(struct TalkContext *Ctxt, char *alias, struct UserObject *uo, struct InputDevice *io);

/* gt_assoc.c */
extern int ASSOC_add(struct TalkContext *Ctxt, char *match, char *app_exec);
extern int ASSOC_number();
extern void ASSOC_print(struct TalkContext *Ctxt);
extern int ASSOC_fork_assoc(struct TalkContext *Ctxt, char *file);

#else
/* gt_forkap.c */
extern int FORK_pid_number();
extern void FORK_pid_print();
extern int FORK_try();
extern void FORK_nuke_child_processes();
extern int FORK_kill_children();
extern int FORK_grabkey();
extern void FORK_save_pid();

/* gt_shapp.c */
extern int SHAPP_add();
extern int SHAPP_verify();
extern int SHAPP_number();
extern void SHAPP_print();
extern int SHAPP_fork_shared();
extern int SHAPP_fork_shared_unsolicited();

/* gt_assoc.c */
extern int ASSOC_add();
extern int ASSOC_number();
extern void ASSOC_print();
extern int ASSOC_fork_assoc();

#endif

#endif /* GTPROC_H */
