;;;; Copyright (C) 2001, 2004 Dave Lambert
;;;; 
;;;; This program is free software; you can redistribute it and/or modify
;;;; it under the terms of the GNU General Public License as published by
;;;; the Free Software Foundation; either version 2, or (at your option)
;;;; any later version.
;;;; 
;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License
;;;; along with this software; see the file COPYING.  If not, write to
;;;; the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
;;;; Boston, MA 02111-1307 USA
;;;; 

(define-module (database simplesql)
  #:use-module (ice-9 optargs))

(load-extension "libguile-database-simplesql" "simplesql_extension_init")


;; Declare the exported functions.

(export	simplesql-open simplesql-query simplesql-close 
	simplesql-database? simplesql-escape)

(define (simplesql-open . args)
  (let* ((original-slots '(#:api #:database #:host #:user #:password))
	 (all-slots (cons* #:port original-slots)))
    (letrec ((pass-one (lambda (done raw slots)
			 (cond ((null? raw) done)
			       ((keyword? (car raw)) (pass-two done raw))
			       (else (pass-one (cons* (car slots) (car raw) done)
					       (cdr raw)
					       (cdr slots))))))
	     (pass-two (lambda (done raw)
			 (cond ((null? raw)
				done)
			       ((member (car raw) done) 
				(throw 'duplicate-argument (car raw)))
			       ((not (member (car raw) all-slots))
				(throw 'unrecognized-keyword (car raw)))
			       ((or (null? (cdr raw))
				    (keyword? (cadr raw)))
				(throw 'malformed-keyword-list raw))
			       (else (pass-two (cons* (car raw) (cadr raw) done)
					       (cddr raw))))))
	     (caller (lambda* (#:key api database host port user password)
			      (cond ((not api)
				     (throw 'missing-argument #:api))
				    ((not database)
				     (throw 'missing-argument #:database))
				    (else
				     (%simplesql-open api database host port user password))))))
      (apply caller (pass-one '() args original-slots)))))


;; Provide deprecated aliases.

(export simplesql-db?)

(export	sql-open sql-query sql-close sql-db? sql-escape)

(define simplesql-db? simplesql-database?)

(define sql-open simplesql-open)

(define sql-query simplesql-query)

(define sql-close simplesql-close)

(define sql-db? simplesql-db?)

(define sql-escape simplesql-escape)
