// -*- C++ -*-

#ifndef _MANAGEONESUPERBLOCK_H_
#define _MANAGEONESUPERBLOCK_H_

template <class SuperHeap>
class ManageOneSuperblock : public SuperHeap {
public:

  typedef typename SuperHeap::SuperblockType SuperblockType;

  ManageOneSuperblock (void)
    : _current (NULL)
  {}

  void dumpStats (void) {
#ifndef NDEBUG
    if (_current) {
      fprintf (stderr, "ManageOneSuperblock: superblock = %x\n", _current);
      _current->dumpStats();
    }
    SuperHeap::dumpStats();
#endif
  }


  inline void * malloc (size_t sz) {
    if (_current) {
      void * ptr = _current->malloc (sz);
      if (ptr) {
	return ptr;
      }
    }
    return slowMallocPath (sz);
  }

#if 1
  SuperblockType * getEmpty (void) {
    // If the current superblock is completely empty,
    // give it up.
    if (_current &&
	(_current->getObjectsFree() == _current->getTotalObjects())) {
	SuperHeap::put (_current);
	_current = NULL;
    }
    return SuperHeap::getEmpty();
  }
#endif

  inline void free (void * ptr) {
    SuperblockType * s = SuperHeap::getSuperblock (ptr);
    if (s == _current) {
      _current->free (ptr);
    } else {
      SuperHeap::free (ptr);
    }
  }

  SuperblockType * get (void) {
    SuperblockType * s = SuperHeap::get();
    if (!s) {
      s = _current;
      _current = NULL;
    }
    if (s) {
      assert (s->isValidSuperblock());
    }
    return s;
  }

  inline void put (SuperblockType * s) {
    if (s) {
      assert (s->isValidSuperblock());
    }
    if (_current) {
      SuperHeap::put (_current);
    }
    _current = s;
  }

private:

  void * slowMallocPath (size_t sz) {
    // Obtain a superblock and return an object from it.
    while (true) {
      // If we don't yet have a current superblock, get one.
      if (_current == NULL) {
	_current = SuperHeap::get();
	if (_current == NULL) {
	  // Oops - the SuperHeap is *also* out of memory.
	  return NULL;
	}
      }
      assert (_current != NULL);
      void * ptr = _current->malloc (sz);
      if (ptr) {
	// Success.
	return ptr;
      } else {
	// We're out of memory in the current superblock. Give it back.
	// We'll get another one next time.
	SuperHeap::put (_current);
	_current = NULL;
      }
    }
  }

  /// The current superblock.
  SuperblockType * _current;

};


#endif
