#ifndef _HX_H
#define _HX_H 1

#include "hx_types.h"

struct hx_hdr {
	u_int32_t	type,
			trans,
			flag,
			len,
			len2;
	u_int16_t	hc;
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
	u_int8_t	data[0];
#else
	u_int8_t	data[1];
#endif
};

struct hx_data_hdr {
	u_int16_t	type,
			len;
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
	u_int8_t	data[0];
#else
	u_int8_t	data[1];
#endif
};

struct htxf_hdr {
	u_int32_t	magic,
			ref,
			type,
			len;
};

#define HTLC_MAGIC	"TRTPHOTL\0\1\0\2"
#define HTLC_MAGIC_LEN	12
#define HTLS_MAGIC	"TRTP\0\0\0\0"
#define HTLS_MAGIC_LEN	8
#define HTRK_MAGIC	"HTRK\0\1"
#define HTRK_MAGIC_LEN	6
#define HTXF_MAGIC	"HTXF"
#define HTXF_MAGIC_LEN	4
#define HTXF_MAGIC_INT	0x48545846

#define HTRK_TCPPORT	5498
#define HTRK_UDPPORT	5499
#define HTLS_TCPPORT	5500
#define HTXF_TCPPORT	5501

#define HTLC_HDR_NEWS_GETFILE	((u_int32_t) 0x00000065)
#define HTLC_HDR_NEWS_POST	((u_int32_t) 0x00000067)
#define HTLC_HDR_CHAT		((u_int32_t) 0x00000069)
#define HTLC_HDR_LOGIN		((u_int32_t) 0x0000006b)
#define HTLC_HDR_MSG		((u_int32_t) 0x0000006c)
#define HTLC_HDR_USER_KICK	((u_int32_t) 0x0000006e)
#define HTLC_HDR_USER_GETLIST	((u_int32_t) 0x0000012c)
#define HTLC_HDR_USER_GETINFO	((u_int32_t) 0x0000012f)
#define HTLC_HDR_USER_CHANGE	((u_int32_t) 0x00000130)
#define HTLC_HDR_USER_CREATE	((u_int32_t) 0x0000015e)
#define HTLC_HDR_USER_OPEN	((u_int32_t) 0x00000160)
#define HTLC_HDR_FILE_LIST	((u_int32_t) 0x000000c8)
#define HTLC_HDR_FILE_GET	((u_int32_t) 0x000000ca)
#define HTLC_HDR_FILE_PUT	((u_int32_t) 0x000000cb)
#define HTLC_HDR_FILE_DELETE	((u_int32_t) 0x000000cc)
#define HTLC_HDR_FILE_MKDIR	((u_int32_t) 0x000000cd)
#define HTLC_HDR_FILE_GETINFO	((u_int32_t) 0x000000ce)
#define HTLC_HDR_FILE_SETINFO	((u_int32_t) 0x000000cf)
#define HTLC_HDR_FILE_MOVE	((u_int32_t) 0x000000d0)
#define HTLC_HDR_CHAT_CREATE	((u_int32_t) 0x00000070)
#define HTLC_HDR_CHAT_INVITE	((u_int32_t) 0x00000071)
#define HTLC_HDR_CHAT_DECLINE	((u_int32_t) 0x00000072)
#define HTLC_HDR_CHAT_JOIN	((u_int32_t) 0x00000073)
#define HTLC_HDR_CHAT_LEAVE	((u_int32_t) 0x00000074)
#define HTLC_HDR_CHAT_SUBJECT	((u_int32_t) 0x00000078)

#define HTLC_DATA_NICK		((u_int16_t) 0x0066)
#define HTLC_DATA_SOCKET	((u_int16_t) 0x0067)
#define HTLC_DATA_ICON		((u_int16_t) 0x0068)
#define HTLC_DATA_LOGIN		((u_int16_t) 0x0069)
#define HTLC_DATA_PASSWORD	((u_int16_t) 0x006a)
#define HTLC_DATA_HTXF_SIZE	((u_int16_t) 0x006c)
#define HTLC_DATA_OPTION	((u_int16_t) 0x006d)
#define HTLC_DATA_CHAT		((u_int16_t) 0x0065)
#define HTLC_DATA_MSG		((u_int16_t) 0x0065)
#define HTLC_DATA_NEWS_POST	((u_int16_t) 0x0065)
#define HTLC_DATA_FILE		((u_int16_t) 0x00c9)
#define HTLC_DATA_DIR		((u_int16_t) 0x00ca)
#define HTLC_DATA_RFLT		((u_int16_t) 0x00cb)
#define HTLC_DATA_BAN		((u_int16_t) 0x0071)
#define HTLC_DATA_CHAT_REF	((u_int16_t) 0x0072)
#define HTLC_DATA_CHAT_SUBJECT	((u_int16_t) 0x0073)
#define HTLC_DATA_FILE_RENAME	((u_int16_t) 0x00d3)
#define HTLC_DATA_DIR_RENAME	((u_int16_t) 0x00d4)

#define HTLS_HDR_USER_LEAVE		((u_int32_t) 0x0000012e)
#define HTLS_HDR_USER_CHANGE		((u_int32_t) 0x0000012d)
#define HTLS_HDR_TASK			((u_int32_t) 0x00010000)
#define HTLS_HDR_NEWS_POST		((u_int32_t) 0x00000066)
#define HTLS_HDR_MSG			((u_int32_t) 0x00000068)
#define HTLS_HDR_CHAT			((u_int32_t) 0x0000006a)
#define HTLS_HDR_AGREEMENT		((u_int32_t) 0x0000006d)
#define HTLS_HDR_POLITEQUIT		((u_int32_t) 0x0000006f)
#define HTLS_HDR_CHAT_INVITE		((u_int32_t) 0x00000071)
#define HTLS_HDR_CHAT_USER_CHANGE	((u_int32_t) 0x00000075)
#define HTLS_HDR_CHAT_USER_LEAVE	((u_int32_t) 0x00000076)
#define HTLS_HDR_CHAT_SUBJECT		((u_int32_t) 0x00000077)

#define HTLS_DATA_SOCKET		((u_int16_t) 0x0067)
#define HTLS_DATA_TASKERROR		((u_int16_t) 0x0064)
#define HTLS_DATA_OPTION		((u_int16_t) 0x006d)
#define HTLS_DATA_ICON			((u_int16_t) 0x0068)
#define HTLS_DATA_COLOUR		((u_int16_t) 0x0070)
#define HTLS_DATA_NICK			((u_int16_t) 0x0066)
#define HTLS_DATA_USER_LIST		((u_int16_t) 0x012c)
#define HTLS_DATA_NEWS			((u_int16_t) 0x0065)
#define HTLS_DATA_AGREEMENT		((u_int16_t) 0x0065)
#define HTLS_DATA_USER_INFO		((u_int16_t) 0x0065)
#define HTLS_DATA_CHAT			((u_int16_t) 0x0065)
#define HTLS_DATA_MSG			((u_int16_t) 0x0065)
#define HTLS_DATA_FILE_LIST		((u_int16_t) 0x00c8)
#define HTLS_DATA_FILE_ICON		((u_int16_t) 0x00d5)
#define HTLS_DATA_FILE_TYPE		((u_int16_t) 0x00cd)
#define HTLS_DATA_FILE_CREATOR		((u_int16_t) 0x00ce)
#define HTLS_DATA_FILE_SIZE		((u_int16_t) 0x00cf)
#define HTLS_DATA_FILE_NAME		((u_int16_t) 0x00c9)
#define HTLS_DATA_FILE_COMMENT		((u_int16_t) 0x00d2)
#define HTLS_DATA_HTXF_REF		((u_int16_t) 0x006b)
#define HTLS_DATA_HTXF_SIZE		((u_int16_t) 0x006c)
#define HTLS_DATA_CHAT_REF		((u_int16_t) 0x0072)
#define HTLS_DATA_CHAT_SUBJECT		((u_int16_t) 0x0073)

struct hx_filelist_hdr {
	u_int16_t	type,
			len;
	u_int8_t	ftype[4],
			fcreator[4];
	u_int32_t	fsize,
			unknown,
			fnlen;
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
	u_int8_t	fname[0];
#else
	u_int8_t	fname[1];
#endif
};

struct hx_userlist_hdr {
	u_int16_t	type,
			len;
	u_int16_t	sock,
			icon,
			colour,
			nlen;
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
	u_int8_t	nick[0];
#else
	u_int8_t	nick[1];
#endif
};

#define SIZEOF_HX_HDR		(22)
#define SIZEOF_HX_DATA_HDR	(4)
#define SIZEOF_HX_FILELIST_HDR	(24)
#define SIZEOF_HX_USERLIST_HDR	(12)
#define SIZEOF_HTXF_HDR		(16)

#endif /* !_HX_H */
