#include "hx_types.h"
#include <stdlib.h>
#include <string.h>
#include <netinet/in.h>
#include "hx.h"
#include "hxlib.h"
#include "dhargs.h"
#include "term.h"
#include "screen.h"
#include "list.h"
#include "htlc.h"
#include "xmalloc.h"

struct user *user_list = 0;

int getting_list = 0;

void
user_print (struct user *ulist)
{
	register struct user *up;

	term_mode_underline();
	curscr_printf("\nsocket | nick                            |  icon | level | stat |");
	term_mode_clear();
	for (up = ulist; up; up = up->next)
		curscr_printf("\n %5u | %s%-31s%s | %5u | %5s | %4s |",
			up->sock,
			up->colour % 4 > 1 ?
			(up->colour % 2 ? term_colour(RED) : term_colour(RED_BOLD)) :
			(up->colour % 2 ? term_colour(GREEN) : term_colour(GREEN_BOLD)),
			up->nick, term_colour(DEFAULT), up->icon,
			up->colour % 4 > 1 ? "ADMIN" : "USER", up->colour % 2 ? "AWAY" : "\0");
}

void
user_print_search (struct user *ulist, const char *str)
{
	register struct user *up;

	term_mode_underline();
	curscr_printf("\nsocket | nick                            |  icon | level | stat |");
	term_mode_clear();
	for (up = ulist; up; up = up->next)
		if (strstr((const char *)up->nick, str))
			curscr_printf("\n %5u | %s%-31s%s | %5u | %5s | %4s |",
				up->sock,
				up->colour % 4 > 1 ?
				(up->colour % 2 ? term_colour(RED) : term_colour(RED_BOLD)) :
				(up->colour % 2 ? term_colour(GREEN) : term_colour(GREEN_BOLD)),
				up->nick, term_colour(DEFAULT), up->icon,
				up->colour % 4 > 1 ? "ADMIN" : "USER", up->colour % 2 ? "AWAY" : "\0");
}

int cmd_who (int argc, char *const *argv);

int
cmd_who (int argc, char *const *argv)
{
	if (!user_list && !getting_list) {
		getting_list = 1;
		task_new(hx_trans, rcv_user_list, 0, &user_list);
		htlc_snd_user_getlist();
	}
	if (argc < 2)
		user_print(user_list);
	else
		user_print_search(user_list, argv[1]);

	return 0;
}

void
user_kill (struct user **ulp)
{
	register struct user *next, *up = *ulp;

	while (up) {
		next = up->next;
		xfree(up);
		up = next;
	}
	*ulp = 0;
}

u_int32_t
sock_lookup_nick (const char *nick, u_int8_t nlen)
{
	register struct user *up, *usr = 0;

	for (up = user_list; up; up = up->next)
		if (!memcmp(up->nick, nick, nlen)) {
			if (!usr || (up->nlen == nlen && usr->nlen != nlen))
				usr = up;
			else if (usr->nlen != nlen || (usr->nlen == up->nlen))
				return 0;
		}

	if (usr)
		return usr->sock;
	else
		return 0;
}

struct user *
user_lookup_sock (struct user *ulist, u_int32_t sock)
{
	register struct user *up;

	for (up = ulist; up; up = up->next)
		if (up->sock == sock)
			return up;

	return 0;
}

struct user *
user_new (struct user **ulp)
{
	struct user *usr;

	usr = xmalloc(sizeof *usr);
	memset(usr, 0, sizeof *usr);
	LISTADD(struct user *, (*ulp), usr)

	return usr;
}

void
rcv_user_list (void *ulist_ptr)
{
	struct hx_userlist_hdr *uh;
	struct user *usr, **ulp = (struct user **)ulist_ptr;

	getting_list = 0;
	dh_start(&(hx_buf[SIZEOF_HX_HDR]), hx_pos - SIZEOF_HX_HDR)
		if (ntohs(dh->type) == HTLS_DATA_USER_LIST) {
			uh = (struct hx_userlist_hdr *)dh;
			usr = user_new(ulp);
			usr->sock = (u_int32_t)ntohs(uh->sock);
			usr->icon = (u_int16_t)ntohs(uh->icon);
			usr->colour = (u_int16_t)ntohs(uh->colour);
			usr->nlen = (u_int8_t)(ntohs(uh->nlen) > 31 ? 31 : ntohs(uh->nlen));
			memcpy(usr->nick, uh->nick, usr->nlen);
			usr->nick[usr->nlen] = 0;
		}
	dh_end()
}

void
rcv_user_change (void)
{
	u_int32_t sock = 0, icon = 0, colour = 0x7f000001;
	u_int8_t nick[32], nlen = 0;
	struct user *usr;

	dh_start(&(hx_buf[SIZEOF_HX_HDR]), hx_pos - SIZEOF_HX_HDR)
		switch (ntohs(dh->type)) {
			case HTLS_DATA_SOCKET:
				dh_getint(sock);
				break;
			case HTLS_DATA_ICON:
				dh_getint(icon);
				break;
			case HTLS_DATA_NICK:
				nlen = ntohs(dh->len) > 31 ? 31 : ntohs(dh->len);
				memcpy(nick, dh->data, nlen);
				nick[nlen] = 0;
				break;
			case HTLS_DATA_COLOUR:
				dh_getint(colour);
				break;
		}
	dh_end()
	if (!(usr = user_lookup_sock(user_list, sock))) {
		usr = user_new(&user_list);
		usr->sock = (u_int32_t)sock;
		curscr_printf("\n <\xa5> join: %.*s [%u:%u:%u]",
				nlen, nick, sock, (u_int16_t)icon, (u_int16_t)colour);
	} else {
		curscr_printf("\n <\xa5> %s [%u:%u:%u] is now known as %.*s [%u:%u:%u]",
				usr->nick, usr->sock, usr->icon, usr->colour,
				nlen, nick, sock, (u_int16_t)icon, (u_int16_t)colour);
	}
	if (nlen) {
		usr->nlen = nlen;
		memcpy(usr->nick, nick, nlen);
		usr->nick[nlen] = 0;
	}
	if (icon)
		usr->icon = (u_int16_t)icon;
	if (colour != 0x7f000001)
		usr->colour = (u_int16_t)colour;
	hx_reset();
}

void
rcv_user_leave (void)
{
	u_int32_t sock = 0;
	struct user *usr;

	dh_start(&(hx_buf[SIZEOF_HX_HDR]), hx_pos - SIZEOF_HX_HDR)
		switch (ntohs(dh->type)) {
			case HTLS_DATA_SOCKET:
				dh_getint(sock);
				if ((usr = user_lookup_sock(user_list, sock))) {
					curscr_printf("\n <\xa5> parts: %s [%u:%u:%u]",
					usr->nick, usr->sock, usr->icon, usr->colour);
					LISTREM(struct user *, user_list, usr)
					xfree(usr);
				}
				break;
		}
	dh_end()
	hx_reset();
}
