/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: Button.h,v 1.12 2004/01/26 11:17:48 comix Exp $
 *
 */


#ifndef BUTTON_H
#define BUTTON_H

#include <qwidget.h>
#include <qpixmap.h>
#include <string>
using std::string;

#include <lib/Object.h>



/**
 * Generic Button with pixmaps
 */
class Button : public QWidget, public Object {
	Q_OBJECT

	public:
		Button(QWidget * parent, QSize size, string onImg, string offImg, string overImg);
		~Button();
		bool isPressed() {	return pressed;	}
		void setPressed(bool pressed);
		void drawButton();

	signals:
		void clicked(Button *ref);
		void rightClicked(Button *ref);

	protected:
		bool pressed;

		QPixmap onPixmap;
		QPixmap offPixmap;
		QPixmap overPixmap;

	private:
		bool mouseOver;
		void mousePressEvent(QMouseEvent *ev);
		void mouseReleaseEvent(QMouseEvent *ev);
		void enterEvent(QEvent *ev);
		void leaveEvent(QEvent *ev);




};



/**
 * ToggleButton
 */
class ToggleButton : public Button {
	Q_OBJECT

	public:
		/** Constructor */
		ToggleButton(QWidget * parent, QSize size, string onImg, string offImg, string overImg);
		~ToggleButton();

	private:
		void mousePressEvent(QMouseEvent *ev);
		void mouseReleaseEvent(QMouseEvent *ev);


};



#endif

