/* memory.h
 * - Memory management headers
 *
 * Copyright (c) 1999 Jack Moffitt, Barath Raghavan, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
#ifndef __ICECAST_MEMORY_H
#define __ICECAST_MEMORY_H

#ifdef HAVE_MCHECK_H
#include <mcheck.h>
#endif

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif

#define nmalloc(x) n_malloc (x, __LINE__,__FILE__)
#define nfree(x) n_free (x,__LINE__,__FILE__) ; x=NULL
#define nstrdup(x) n_strdup (x,__LINE__,__FILE__)

typedef struct meminfo_t
{
	int line;
	int size;
	char file[20];
	void *ptr;
	int thread_id;
	time_t time;
} meminfo_t;

void *n_malloc (const unsigned int size, const int lineno, const char *file);
void n_free (void *ptr, const int lineno, const char *file);
char *n_strdup (const char *ptr, const int lineno, const char *file);
char *ice_cat (const char *first, const char *second);
char *ice_itoa (int num);
char *ice_utoa (unsigned long int num);

void initialize_memory_checker ();

#ifdef HAVE_MCHECK_H
void icecast_mcheck_status (enum mcheck_status STATUS);
#endif

#endif





