/* GNOME INPUT METHOD SETTINGS DAEMON
 *
 * Copyright 2003 Sun Microsystems Inc.
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <config.h>

#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gnome.h>
#include <gconf/gconf-client.h>
#include <stdarg.h>

#define IM_KEY_DIR    "/desktop/gnome/input_methods"
#define ENABLE_IM_KEY IM_KEY_DIR "/support"
#define ENABLE_STATUS_KEY IM_KEY_DIR "/status"
#define ENABLE_LOOKUP_KEY IM_KEY_DIR "/lookup"
#define STATUS_PLACEMENT_KEY IM_KEY_DIR "/status_placement"
#define GTK_STATUS_STYLE_KEY "/desktop/gnome/interface/gtk-im-status-style"

/* For StatusPlacement */
typedef enum {
  ON_DESKTOP_PANEL,
  ATTACH_TO_APP_FRAME
} IMStatusPlacement;

typedef enum {
  IM_OFF = 0,
  IM_ON
} IMEnabled;

static const char *on_desktop_panel = "panel"; /* XIMStatusNothing */
static const char *attach_to_application_frame = "application"; /* XIMStatusCallbacks */

/* For gtk-im-status-style */
static const char *nothing = "nothing"; /* XIMStatusNothing */
static const char *callback = "callback"; /* XIMStatusCallbacks */
static const char *none = "none"; 	/* XIMStatusNone */

static const char *enabled = "enabled";
static const char *disabled = "diasbled";

typedef struct {
  IMEnabled im_enabled;
  IMEnabled status_enabled;
  IMEnabled lookup_enabled;
  IMStatusPlacement status_placement;
} IMSettings;

static IMSettings current_setting;
static GdkAtom im_settings_atom = GDK_NONE;
static const char *_IM_SETTINGS = "_IM_SETTINGS";

static void
set_im_settings_property ()
{
  GdkWindow *root_window = gdk_get_default_root_window ();

  if (im_settings_atom == GDK_NONE)
    im_settings_atom = gdk_atom_intern (_IM_SETTINGS, FALSE);
  if (im_settings_atom == GDK_NONE)
    return;

  gdk_property_change (root_window,
		       im_settings_atom, im_settings_atom,
		       8, GDK_PROP_MODE_REPLACE,
		       (guchar *)&current_setting, sizeof (IMSettings));

  {
    GdkAtom  type;
    guchar   *data = NULL;
    gint     format;
    gint     length = 0;
    gdk_property_get (root_window,
		      im_settings_atom, im_settings_atom,
		      0, INT_MAX, FALSE,
		      &type, &format, &length, &data);
    if (data)
      {
	IMSettings *new_settings = (IMSettings*)data;

	g_printf ("GNOME_IM_ENABLED=%s\n",
		  new_settings->im_enabled == IM_ON ? "yes" : "no");
	g_printf ("GNOME_IM_STATUS_ENABLED=%s\n", 
		  new_settings->status_enabled == IM_ON ? "yes" : "no");
	g_printf ("GNOME_IM_LOOKUP_ENABLED=%s\n",
		  new_settings->lookup_enabled == IM_ON ? "yes" : "no");
	g_printf ("GNOME_IM_STATUS_PLACEMENT=%s\n",
		  new_settings->status_placement ? "application_frame" : "panel");
	g_free (data);
      }
  }
}


static void
setup ()
{
  GConfClient *client;
  gboolean im_enabled, status_enabled, lookup_enabled;
  char *str = NULL;

  client = gconf_client_get_default ();

  str = NULL;
  str = gconf_client_get_string (client,
				 ENABLE_IM_KEY, NULL);
  if (str && strcmp (str, disabled) == 0)
    im_enabled = FALSE;
  else
    im_enabled = TRUE;
  g_free (str);

  str = NULL;
  str = gconf_client_get_string (client,
				 ENABLE_STATUS_KEY, NULL);
  if (str && strcmp (str, disabled) == 0)
    status_enabled = FALSE;
  else
    status_enabled = TRUE;
  g_free (str);

  str = NULL;
  str = gconf_client_get_string (client,
				 ENABLE_LOOKUP_KEY, NULL);
  if (str && strcmp (str, disabled) == 0)
    lookup_enabled = FALSE;
  else
    lookup_enabled = TRUE;
  g_free (str);

  current_setting.im_enabled = im_enabled ? IM_ON : IM_OFF;
  current_setting.status_enabled = status_enabled ? IM_ON : IM_OFF;
  current_setting.lookup_enabled = lookup_enabled ? IM_ON : IM_OFF;

  str = NULL;
  str = gconf_client_get_string (client,
				 STATUS_PLACEMENT_KEY, NULL);

  if (str && (strcmp (str, attach_to_application_frame) == 0))
    current_setting.status_placement = ATTACH_TO_APP_FRAME;
  else
    current_setting.status_placement = ON_DESKTOP_PANEL;
  g_free (str);

  set_im_settings_property ();
}

int
main (int argc, char *argv[])
{
  bindtextdomain (GETTEXT_PACKAGE, GNOMELOCALEDIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);

  gnome_program_init ("gnome-im-settings-daemon", VERSION,
		      LIBGNOMEUI_MODULE, argc, argv,
		      GNOME_PARAM_APP_DATADIR, GNOMECC_DATA_DIR,
		      NULL);
  setup ();

  return 0;
}
