#ifndef IMINPUTCONTEXT_HH_
#define IMINPUTCONTEXT_HH_
#include <list>
#include "basictype.hh"
#include "ICHandler.hh"

class IMConnection;
class LEMgr;
class LEContext;

class IMInputContext : public ICHandler
{
    IMConnection *pimc;

    typedef list<LEContext*> LEContextList;
    LEContextList leclist;
    LEContext *pcur_lec;

    ICAttribute attr;

    LEMgr* get_lemgr();
    LEContext* create_lecontext();
    LEContext* get_current_lecontext();
    bool switch_lecontext(const ICAttribute &attr);

  public:
    IMConnection *get_imconnection()
    { return pimc; }
    void get_lecontext_args(
	vector<IMArg> &args
    );
    IMInputContext(
	IMConnection *pimc,
	const ICAttribute &attr
    );
    virtual void destroy();
  protected:
    ~IMInputContext();

  public:
    // ICHandler realization.
    virtual bool send_event(
	IMLExec* pimlex,
	IMInputEvent* pimevent
    );
    virtual const ICAttribute& get_icattr();
    virtual bool set_icattr(
    	ICAttribute &attr
    );
    virtual bool toggle_conversion(
	IMLExec *pimlex,
	bool flag
    );
    virtual bool reset(
	IMLExec *pimlex
    );
    virtual bool destroy(
	IMLExec *pimlex
    );

    /* obsolete API!!!! */
    virtual bool toggle_focus(
	IMLExec *pimlex,
	bool flag
    );
};

#endif /* not IMINPUTCONTEXT_HH_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
